/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.factory.AchievementFactory;
import net.sf.esfinge.gamification.mechanics.Game;

public class GameFileStorage
extends Game {
    private String key;
    private Properties props;
    private static File dir = null;
    private static String delim = "|";

    public GameFileStorage(String fileName) {
        dir = new File(fileName);
    }

    @Override
    public void insertAchievement(Object user, Achievement a) {
        String className = a.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        this.key = user.toString() + delim + className + delim + a.getName();
        try {
            this.props = new Properties();
            FileInputStream inputFile = new FileInputStream(dir);
            this.props.load(inputFile);
            this.saveProperty(a);
            FileOutputStream outputFile = new FileOutputStream(dir);
            this.props.store(outputFile, null);
            outputFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Achievement '" + this.key + "' could not be written into file properly." + e);
        }
    }

    private void saveProperty(Achievement a) {
        String value = "";
        for (Method m : a.getClass().getDeclaredMethods()) {
            if ("getName".equals(m.getName()) || !m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0) continue;
            try {
                value = m.invoke((Object)a, new Object[0]).toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Achievement '" + this.key + "' could not be written into file properly." + e);
            }
        }
        this.props.setProperty(this.key, value);
    }

    @Override
    public void deleteAchievement(Object user, Achievement a) {
        String className = a.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        this.key = user.toString() + delim + className + delim + a.getName();
        try {
            this.props = new Properties();
            FileInputStream inputFile = new FileInputStream(dir);
            this.props.load(inputFile);
            this.props.remove(this.key);
            FileOutputStream outputFile = new FileOutputStream(dir);
            this.props.store(outputFile, null);
            outputFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Achievement '" + this.key + "' could not be deleted from file properly." + e);
        }
    }

    @Override
    public Achievement getAchievement(Object user, String achievName) {
        Achievement a = null;
        try {
            Properties prop = new Properties();
            FileInputStream inputFile = new FileInputStream(dir);
            prop.load(inputFile);
            for (String key : prop.stringPropertyNames()) {
                String userName = key.substring(0, key.indexOf(delim));
                String achievementType = key.substring(key.indexOf(delim) + 1, key.lastIndexOf(delim));
                String achievementName = key.substring(key.lastIndexOf(delim) + 1);
                String achievementValue = prop.getProperty(key);
                if (!user.toString().equals(userName) || !achievementName.equals(achievName)) continue;
                a = AchievementFactory.createAchievement(achievementType, achievementName, achievementValue);
            }
            FileOutputStream file = new FileOutputStream(dir);
            prop.store(file, null);
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return a;
    }

    @Override
    public Map<String, Achievement> getAchievements(Object user) {
        HashMap<String, Achievement> achievements = new HashMap<String, Achievement>();
        try {
            Properties prop = new Properties();
            FileInputStream inputFile = new FileInputStream(dir);
            prop.load(inputFile);
            for (String key : prop.stringPropertyNames()) {
                String userName = key.substring(0, key.indexOf(delim));
                String achievementType = key.substring(key.indexOf(delim) + 1, key.lastIndexOf(delim));
                String achievementName = key.substring(key.lastIndexOf(delim) + 1);
                String achievementValue = prop.getProperty(key);
                if (!user.toString().equals(userName)) continue;
                Achievement a = AchievementFactory.createAchievement(achievementType, achievementName, achievementValue);
                achievements.put(a.getName(), a);
            }
            FileOutputStream file = new FileOutputStream(dir);
            prop.store(file, null);
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return achievements;
    }

    @Override
    public void updateAchievement(Object user, Achievement a) {
        this.insertAchievement(user, a);
    }

    @Override
    public Map<String, Achievement> getAllAchievements(Class<? extends Achievement> type) {
        HashMap<String, Achievement> achievements = null;
        try {
            Properties prop = new Properties();
            FileInputStream inputFile = new FileInputStream(dir);
            prop.load(inputFile);
            achievements = new HashMap<String, Achievement>();
            for (String key : prop.stringPropertyNames()) {
                String userName = key.substring(0, key.indexOf(delim));
                String achievementType = key.substring(key.indexOf(delim) + 1, key.lastIndexOf(delim));
                String achievementName = key.substring(key.lastIndexOf(delim) + 1);
                String achievementValue = prop.getProperty(key);
                if (!achievementType.equals(type.getSimpleName())) continue;
                Achievement achievement = AchievementFactory.createAchievement(achievementType, achievementName, achievementValue);
                achievements.put(userName, achievement);
            }
            FileOutputStream file = new FileOutputStream(dir);
            prop.store(file, null);
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return achievements;
    }
}

