/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sf.esfinge.gamification.annotation.GamificationProcessor;
import net.sf.esfinge.gamification.mechanics.Game;
import net.sf.esfinge.gamification.processors.AchievementProcessor;

public class GameInvoker {
    private static GameInvoker instance;
    private Game game;

    public static GameInvoker getInstance() {
        if (instance == null) {
            instance = new GameInvoker();
        }
        return instance;
    }

    private GameInvoker() {
    }

    public void setGame(Game g) {
        this.game = g;
    }

    public Game getGame() {
        return this.game;
    }

    public void registerAchievment(Object encapsulated, Method method, Object[] args) throws Throwable {
        for (AchievementProcessor ap : this.getAnnotations(method)) {
            ap.process(this.game, encapsulated, method, args);
        }
    }

    private List<AchievementProcessor> getAnnotations(Method method) throws InstantiationException, IllegalAccessException {
        ArrayList<AchievementProcessor> apList = new ArrayList<AchievementProcessor>();
        for (Annotation an : method.getAnnotations()) {
            this.createAchievementProcessor(an).ifPresent(ap -> apList.add((AchievementProcessor)ap));
        }
        for (Annotation an : method.getClass().getAnnotations()) {
            this.createAchievementProcessor(an).ifPresent(ap -> apList.add((AchievementProcessor)ap));
        }
        return apList;
    }

    private Optional<AchievementProcessor> createAchievementProcessor(Annotation an) throws InstantiationException, IllegalAccessException {
        Class<? extends Annotation> anType = an.annotationType();
        if (anType.isAnnotationPresent(GamificationProcessor.class)) {
            GamificationProcessor gp = anType.getAnnotation(GamificationProcessor.class);
            Class<? extends AchievementProcessor> c = gp.value();
            AchievementProcessor ap = c.newInstance();
            ap.receiveAnnotation(an);
            return Optional.of(ap);
        }
        return Optional.empty();
    }
}

