/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.mechanics.Game;
import net.sf.esfinge.gamification.mechanics.database.Storage;
import net.sf.esfinge.gamification.mechanics.database.nosql.MongoStorageFactory;
import org.apache.commons.collections.MapUtils;
import org.bson.Document;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class GameMongoStorage
extends Game {
    private MongoDatabase mongo;
    private MongoCollection<Document> collection;
    private Document document;
    private MongoStorageFactory factory;

    public GameMongoStorage(MongoDatabase mongo) {
        this.mongo = mongo;
        this.document = new Document();
        try {
            this.collection = mongo.getCollection("gamification");
        }
        catch (IllegalArgumentException e) {
            mongo.createCollection("gamification");
        }
        this.factory = new MongoStorageFactory(this.collection);
    }

    @Override
    public void insertAchievement(Object user, Achievement a) {
        Storage storage = this.factory.storageFor(a);
        try {
            storage.insert(user, a);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.document.clear();
    }

    @Override
    public void deleteAchievement(Object user, Achievement a) {
        Storage storage = this.factory.storageFor(a);
        try {
            storage.delete(user, a);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateAchievement(Object user, Achievement a) {
        Storage storage = this.factory.storageFor(a);
        try {
            storage.update(user, a);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Achievement getAchievement(Object user, String achievName) {
        Reflections r = new Reflections("net.sf.esfinge.gamification.mechanics.database.nosql", new Scanner[0]);
        for (Class c : r.getSubTypesOf(Storage.class)) {
            Storage s;
            try {
                Constructor m = c.getConstructor(MongoCollection.class);
                s = (Storage)m.newInstance(this.collection);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating an instance of " + c.getName() + ". A constructor receiving a MongoCollection must be available.", e);
            }
            try {
                Achievement a = s.select(user, achievName);
                if (a == null) continue;
                return a;
            }
            catch (SQLException e) {
                throw new RuntimeException("Database error", e);
            }
        }
        return null;
    }

    @Override
    public Map<String, Achievement> getAchievements(Object user) {
        HashMap<String, Achievement> achievements = new HashMap<String, Achievement>();
        Reflections r = new Reflections("net.sf.esfinge.gamification.mechanics.database.nosql", new Scanner[0]);
        for (Class c : r.getSubTypesOf(Storage.class)) {
            Storage s;
            try {
                Constructor m = c.getConstructor(MongoCollection.class);
                s = (Storage)m.newInstance(this.collection);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating an instance of " + c.getName() + ". A constructor receiving a MongoCollection must be available.", e);
            }
            try {
                Map<String, Achievement> a = s.select(user);
                MapUtils.putAll(achievements, (Object[])a.entrySet().toArray());
            }
            catch (SQLException e) {
                throw new RuntimeException("Database error", e);
            }
        }
        return achievements;
    }

    @Override
    public Map<String, Achievement> getAllAchievements(Class<? extends Achievement> type) {
        Map<String, Achievement> result = null;
        try {
            Storage storage = this.factory.storageFor(type.newInstance());
            result = storage.selectAll();
        }
        catch (IllegalAccessException | InstantiationException | SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

