/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.guardian;

import java.util.Optional;
import net.sf.esfinge.gamification.exception.GamificationConfigurationException;
import net.sf.esfinge.gamification.mechanics.Game;
import net.sf.esfinge.gamification.proxy.GameInvoker;
import net.sf.esfinge.gamification.user.UserStorage;
import org.esfinge.guardian.annotation.config.PopulatorClass;
import org.esfinge.guardian.context.AuthorizationContext;
import org.esfinge.guardian.populator.Populator;

@PopulatorClass(value=GamificationAuthorizationPopulator.class)
public class GamificationAuthorizationPopulator
implements Populator {
    public void populate(AuthorizationContext context) {
        Optional<Game> optionalGame = Optional.ofNullable(GameInvoker.getInstance().getGame());
        Optional<Object> optionalUser = Optional.ofNullable(UserStorage.getUserID());
        if (!optionalGame.isPresent()) {
            throw new GamificationConfigurationException("Game cannot be found, use setGame method of GameInvoker class");
        }
        context.getEnvironment().put((Object)"game", (Object)optionalGame.get());
        if (!optionalUser.isPresent()) {
            throw new GamificationConfigurationException("Current user cannot be found, use setUser method of UserStorage class");
        }
        context.getResource().put((Object)"currentUser", optionalUser.get());
    }
}

