/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.sf.esfinge.gamification.exception.GamificationConfigurationException;
import net.sf.esfinge.gamification.proxy.GameInvoker;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.validate.MetadataValidator;

public class GameProxy
implements InvocationHandler {
    private Object encapsulated;

    private GameProxy(Object encapsulated) {
        this.encapsulated = encapsulated;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object returnValue = method.invoke(this.encapsulated, args);
            GameInvoker gameInvoker = GameInvoker.getInstance();
            gameInvoker.registerAchievment(this.encapsulated, method, args);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static <T> T createProxy(T encapsulated) {
        Object obj = Proxy.newProxyInstance(encapsulated.getClass().getClassLoader(), encapsulated.getClass().getInterfaces(), (InvocationHandler)new GameProxy(encapsulated));
        try {
            MetadataValidator.validateMetadataOn(encapsulated.getClass());
            Class<?>[] classArray = encapsulated.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interf = classArray[n2];
                MetadataValidator.validateMetadataOn(interf);
                ++n2;
            }
        }
        catch (AnnotationValidationException e) {
            throw new GamificationConfigurationException("Invalid annotation configuration", e);
        }
        return (T)obj;
    }
}

