/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics.database.nosql;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.achievement.Point;
import net.sf.esfinge.gamification.mechanics.database.Storage;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoPointStorage
implements Storage {
    private MongoCollection<Document> collection;

    public MongoPointStorage(MongoCollection<Document> c) {
        this.collection = c;
    }

    @Override
    public void insert(Object user, Achievement a) throws SQLException {
        Document document = this.toDocument(user, a);
        this.collection.insertOne((Object)document);
    }

    @Override
    public Achievement select(Object user, String name) throws SQLException {
        BasicDBObject query = new BasicDBObject().append("user", user).append("achievement.name", (Object)name).append("achievement.type", (Object)"Point");
        Optional<Document> achievement = Optional.ofNullable((Document)this.collection.find((Bson)query).first());
        Point p = null;
        if (achievement.isPresent()) {
            Document achievementProperties = (Document)achievement.get().get((Object)"achievement", Document.class);
            p = new Point(achievementProperties.getInteger((Object)"quantity"), name);
        }
        return p;
    }

    @Override
    public Map<String, Achievement> select(Object user) throws SQLException {
        HashMap<String, Achievement> achievements = new HashMap<String, Achievement>();
        FindIterable results = this.collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"user", (Object)user), Filters.eq((String)"achievement.type", (Object)"Point")})).projection(Projections.fields((Bson[])new Bson[]{Projections.exclude((String[])new String[]{"achievement.type"}), Projections.excludeId()}));
        for (Document result : results) {
            Document achievement = (Document)result.get((Object)"achievement", Document.class);
            Point p = new Point(achievement.getInteger((Object)"quantity"), achievement.getString((Object)"name"));
            achievements.put(p.getName(), p);
        }
        return achievements;
    }

    @Override
    public void update(Object user, Achievement a) throws SQLException {
        BasicDBObject query = new BasicDBObject().append("user", user).append("achievement.name", (Object)a.getName()).append("achievement.type", (Object)"Point");
        Document update = new Document("$set", (Object)new Document().append("achievement.quantity", (Object)((Point)a).getQuantity()));
        this.collection.updateOne((Bson)query, (Bson)update);
    }

    @Override
    public void delete(Object user, Achievement a) throws SQLException {
        this.collection.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"user", (Object)user), Filters.eq((String)"achievement.name", (Object)a.getName()), Filters.eq((String)"achievement.type", (Object)"Point")}));
    }

    @Override
    public Map<String, Achievement> selectAll() throws SQLException {
        HashMap<String, Achievement> achievements = new HashMap<String, Achievement>();
        FindIterable results = this.collection.find(Filters.eq((String)"achievement.type", (Object)"Point"));
        for (Document result : results) {
            Document achievement = (Document)result.get((Object)"achievement", Document.class);
            Point p = new Point(achievement.getInteger((Object)"quantity"), achievement.getString((Object)"name"));
            achievements.put(p.getName(), p);
        }
        return achievements;
    }

    private Document toDocument(Object user, Achievement a) {
        Point p = (Point)a;
        return new Document().append("user", user).append("achievement", (Object)new BasicDBObject("type", (Object)"Point").append("name", (Object)p.getName()).append("quantity", (Object)p.getQuantity()));
    }
}

