/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.achievement;

import net.sf.esfinge.gamification.achievement.Achievement;

public class Reward
implements Achievement {
    private String name;
    private boolean used;

    public Reward(String name) {
        this.name = name;
        this.used = false;
    }

    public Reward(String name, boolean used) {
        this.name = name;
        this.used = used;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isUsed() {
        return this.used;
    }

    @Override
    public void incrementAchievement(Achievement a) {
        if (!a.getName().equals(this.getName()) || !(a instanceof Reward)) {
            throw new RuntimeException("The achievement should be of the same type");
        }
        this.used = ((Reward)a).isUsed();
    }

    @Override
    public boolean removeAchievement(Achievement r) {
        if (!r.getName().equals(this.getName()) || !(r instanceof Reward)) {
            throw new RuntimeException("The achievement should be of the same type");
        }
        this.used = true;
        return false;
    }

    public String toString() {
        return "Reward Achieved - " + this.name + ": " + this.used;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Reward)) {
            return false;
        }
        Reward r = (Reward)o;
        return this.name.equals(r.name) && this.used == r.used;
    }
}

