/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.achievement;

import net.sf.esfinge.gamification.achievement.Achievement;

public class Point
implements Achievement {
    private Integer quantity;
    private String name;

    public Point(Integer quantity, String name) {
        this.quantity = quantity;
        this.name = name;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void incrementAchievement(Achievement a) {
        if (!a.getName().equals(this.getName()) || !(a instanceof Point)) {
            throw new RuntimeException("The achievement should be of the same type");
        }
        this.quantity = this.quantity + ((Point)a).getQuantity();
    }

    @Override
    public boolean removeAchievement(Achievement r) {
        if (!r.getName().equals(this.getName()) || !(r instanceof Point)) {
            throw new RuntimeException("The achievement should be of the same type");
        }
        this.quantity = this.quantity - ((Point)r).getQuantity();
        return this.quantity <= 0;
    }

    public String toString() {
        return "Points Achieved - " + this.name + ": " + this.quantity;
    }

    public boolean equals(Object o) {
        Point p = (Point)o;
        return this.name == p.name && this.quantity == p.quantity;
    }
}

