/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.processors;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.esfinge.gamification.achievement.Point;
import net.sf.esfinge.gamification.annotation.RemovePointsToParam;
import net.sf.esfinge.gamification.mechanics.Game;
import net.sf.esfinge.gamification.processors.AchievementProcessor;
import net.sf.esfinge.gamification.utils.ReflectionUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class RemovePointsToParameterProcessor
implements AchievementProcessor {
    private int quantity;
    private String name;
    private String parameterName;
    private String propertyName;

    @Override
    public void receiveAnnotation(Annotation an) {
        RemovePointsToParam rptu = (RemovePointsToParam)an;
        this.quantity = rptu.quantity();
        this.name = rptu.name();
        this.parameterName = rptu.param();
        this.propertyName = rptu.prop();
    }

    @Override
    public void process(Game game, Object encapsulated, Method method, Object[] args) {
        int index = ReflectionUtils.findParameterNamed(method, this.parameterName);
        Object target = args[index];
        if (!this.propertyName.equals("")) {
            try {
                target = PropertyUtils.getProperty((Object)target, (String)this.propertyName);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Cannot retrieve property '" + this.propertyName + "' from class " + target.getClass(), e);
            }
        }
        Point p = new Point(this.quantity, this.name);
        game.removeAchievement(target, p);
    }

    @Override
    public void process(Game game, Object encapsulated, Class<? extends Method> class1, Object[] args) {
    }
}

