/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics.database;

import java.sql.Connection;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.achievement.Point;
import net.sf.esfinge.gamification.achievement.Ranking;
import net.sf.esfinge.gamification.achievement.Reward;
import net.sf.esfinge.gamification.achievement.Trophy;
import net.sf.esfinge.gamification.mechanics.database.PointStorage;
import net.sf.esfinge.gamification.mechanics.database.RankingStorage;
import net.sf.esfinge.gamification.mechanics.database.RewardStorage;
import net.sf.esfinge.gamification.mechanics.database.Storage;
import net.sf.esfinge.gamification.mechanics.database.TrophyStorage;

public class StorageFactory {
    private Connection connection;

    public StorageFactory(Connection connection) {
        this.connection = connection;
    }

    public Storage storageFor(Achievement a) {
        if (a instanceof Point) {
            return new PointStorage(this.connection);
        }
        if (a instanceof Ranking) {
            return new RankingStorage(this.connection);
        }
        if (a instanceof Reward) {
            return new RewardStorage(this.connection);
        }
        if (a instanceof Trophy) {
            return new TrophyStorage(this.connection);
        }
        throw new RuntimeException("Cannot create Storage for " + a.getClass().getName());
    }
}

