/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.event.BonusBuilder;
import net.sf.esfinge.gamification.event.annotation.EventListenerImplementation;
import net.sf.esfinge.gamification.event.annotation.GamificationListener;
import net.sf.esfinge.gamification.event.listener.EventListener;
import net.sf.esfinge.gamification.listener.AchievementListener;
import net.sf.esfinge.gamification.listener.EvaluationAchievementProcessorAchievementoListener;

public abstract class Game {
    private List<AchievementListener> listeners = new ArrayList<AchievementListener>();

    public abstract void insertAchievement(Object var1, Achievement var2);

    public abstract void deleteAchievement(Object var1, Achievement var2);

    public abstract void updateAchievement(Object var1, Achievement var2);

    public abstract Achievement getAchievement(Object var1, String var2);

    public abstract Map<String, Achievement> getAchievements(Object var1);

    public void addAchievement(Object user, Achievement a) {
        Achievement p = this.getAchievement(user, a.getName());
        if (p == null) {
            this.insertAchievement(user, a);
        } else {
            p.incrementAchievement(a);
            this.updateAchievement(user, p);
        }
        this.notifyAdded(user, a);
    }

    public void removeAchievement(Object user, Achievement a) {
        Achievement p = this.getAchievement(user, a.getName());
        if (p.removeAchievement(a)) {
            this.deleteAchievement(user, p);
        } else {
            this.updateAchievement(user, p);
        }
        this.notifyRemoved(user, a);
    }

    public void addListener(AchievementListener listener) {
        this.listeners.add(listener);
    }

    private void notifyAdded(Object user, Achievement a) {
        for (AchievementListener l : this.listeners) {
            l.achievementAdded(this, user, a);
        }
    }

    private void notifyRemoved(Object user, Achievement a) {
        for (AchievementListener l : this.listeners) {
            l.achievementRemoved(this, user, a);
        }
    }

    public BonusBuilder addBonus(Achievement bonus) {
        return new BonusBuilder(this, bonus);
    }

    public void addEventListeners(Object ... configurationObjects) {
        for (Object configurationObject : configurationObjects) {
            Class<?> configurationObjectClazz = configurationObject.getClass();
            if (!configurationObjectClazz.isAnnotationPresent(GamificationListener.class)) continue;
            for (Method m : configurationObjectClazz.getDeclaredMethods()) {
                for (Annotation an : m.getAnnotations()) {
                    if (!an.annotationType().isAnnotationPresent(EventListenerImplementation.class)) continue;
                    try {
                        EventListenerImplementation eventImplementation = an.annotationType().getAnnotation(EventListenerImplementation.class);
                        EventListener<? extends Achievement> eventListener = eventImplementation.value().newInstance();
                        eventListener.setAnnotation(an);
                        eventListener.setMethod(m);
                        eventListener.setConfigurationObject(configurationObject);
                        this.addListener(new EvaluationAchievementProcessorAchievementoListener<Achievement>(eventListener));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

