/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.listener;

import java.util.function.BiPredicate;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.listener.AchievementListener;
import net.sf.esfinge.gamification.mechanics.Game;

public class EvaluationAchievementListener<T extends Achievement>
implements AchievementListener {
    private BiPredicate<T, Object> evaluation;
    private Achievement bonus;

    public EvaluationAchievementListener(BiPredicate<T, Object> evaluation, Achievement bonus) {
        this.evaluation = evaluation;
        this.bonus = bonus;
    }

    @Override
    public void achievementAdded(Game game, Object user, Achievement a) {
        Achievement updated = game.getAchievement(user, a.getName());
        try {
            if (this.evaluation.test(updated, user)) {
                game.addAchievement(user, this.bonus);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void achievementRemoved(Game game, Object user, Achievement a) {
        Achievement updated = game.getAchievement(user, a.getName());
        try {
            if (updated != null && this.evaluation.negate().test(updated, user)) {
                game.removeAchievement(user, this.bonus);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

