/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.achievement;

import net.sf.esfinge.gamification.achievement.Achievement;

public class Ranking
implements Achievement {
    private String name;
    private String level;

    public Ranking(String name, String level) {
        this.name = name;
        this.level = level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLevel() {
        return this.level;
    }

    @Override
    public void incrementAchievement(Achievement a) {
        if (!a.getName().equals(this.getName()) || !(a instanceof Ranking)) {
            throw new RuntimeException("The achievement should be of the same type");
        }
        this.name = ((Ranking)a).getName();
        this.level = ((Ranking)a).getLevel();
    }

    @Override
    public boolean removeAchievement(Achievement r) {
        if (!r.getName().equals(this.getName()) || !(r instanceof Ranking)) {
            throw new RuntimeException("The achievement should be of the same type");
        }
        this.level = null;
        return true;
    }

    public String toString() {
        return "Ranking Achieved - " + this.name + ": " + this.level;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Ranking)) {
            return false;
        }
        Ranking r = (Ranking)o;
        return this.name.equals(r.name) && this.level.equals(r.level);
    }
}

