/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock.parse;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ReferenceType;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.esfinge.classmock.MockClassLoader;
import net.sf.esfinge.classmock.api.IAnnotationReader;
import net.sf.esfinge.classmock.api.IFieldReader;
import net.sf.esfinge.classmock.api.enums.LocationEnum;
import net.sf.esfinge.classmock.api.enums.ModifierEnum;
import net.sf.esfinge.classmock.api.enums.VisibilityEnum;
import net.sf.esfinge.classmock.imp.AnnotationImp;
import net.sf.esfinge.classmock.imp.FieldImp;
import net.sf.esfinge.classmock.imp.MethodImp;
import net.sf.esfinge.classmock.parse.ParseFieldSignature;

public final class ParseMethodSignature {
    private static ParseMethodSignature instance = new ParseMethodSignature();

    private ParseMethodSignature() {
    }

    public static ParseMethodSignature getInstance() {
        return instance;
    }

    public MethodImp parse(String signature) {
        StringBuilder sb = new StringBuilder();
        sb.append("class A {\n");
        if (!signature.contains("(")) {
            sb.append(signature.contains("()") ? signature : signature.concat("()"));
        } else {
            sb.append(signature);
        }
        if (!signature.contains("{}")) {
            sb.append(" {}");
        }
        sb.append("\n}");
        MethodImp method = new MethodImp("NOT_DEFINED");
        CompilationUnit compilationUnit = JavaParser.parse((String)sb.toString());
        compilationUnit.getClassByName("A").ifPresent(clazz -> clazz.getMethods().forEach(md -> {
            method.name(md.getNameAsString());
            method.visibility(this.getVisibility((MethodDeclaration)md));
            method.modifiers(this.getModifiers((MethodDeclaration)md));
            method.returnType(this.getReturnType((MethodDeclaration)md));
            method.exceptions(this.getExceptions((MethodDeclaration)md));
            md.getAnnotations().forEach(an -> this.getAnnotationMethod((AnnotationExpr)an).ifPresent(x -> method.annotation((IAnnotationReader)x)));
            md.getParameters().forEach(p -> this.getField((Parameter)p).ifPresent(x -> method.parameters().add((IFieldReader)x)));
        }));
        return method;
    }

    private Optional<FieldImp> getField(Parameter p) {
        Optional<FieldImp> optional = Optional.empty();
        try {
            optional = Optional.ofNullable(ParseFieldSignature.getInstance().parse(p.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return optional;
    }

    private Optional<AnnotationImp> getAnnotationMethod(AnnotationExpr an) {
        Optional<AnnotationImp> optional = Optional.empty();
        List<String> classes = this.findImportForClasses(an.getNameAsString());
        for (Class<?> clazz : this.loadClasses(classes)) {
            try {
                AnnotationImp annotationImp = new AnnotationImp(clazz.asSubclass(Annotation.class));
                annotationImp.location(LocationEnum.METHOD);
                an.ifNormalAnnotationExpr(normal -> normal.getPairs().forEach(pair -> annotationImp.property(pair.getNameAsString(), pair.getValue().toString().replaceAll("\"", ""))));
                optional = Optional.ofNullable(annotationImp);
                break;
            }
            catch (Exception exception) {
            }
        }
        return optional;
    }

    private Class<?> getReturnType(MethodDeclaration md) {
        Class<Void> clazz = Void.TYPE;
        String returnType = md.getType().asString();
        if (!returnType.equals("void")) {
            ArrayList<String> classNames = new ArrayList<String>();
            if (returnType.contains(".")) {
                classNames.add(returnType.trim());
            } else {
                this.getNativeJavaPackages().forEach(p -> classNames.add(p + returnType.trim()));
            }
            List classes = this.loadClasses(classNames).stream().collect(Collectors.toList());
            clazz = classes.isEmpty() ? Void.TYPE : (Class)classes.get(0);
        }
        return clazz;
    }

    private Class<?>[] getExceptions(MethodDeclaration md) {
        Set<Object> classes = new HashSet();
        for (ReferenceType referenceType : md.getThrownExceptions()) {
            String name = referenceType.asString();
            List<String> classNames = this.findImportForClasses(name);
            classes = this.loadClasses(classNames);
        }
        return (Class[])classes.stream().toArray(Class[]::new);
    }

    private List<String> findImportForClasses(String name) {
        ArrayList<String> classNames = new ArrayList<String>();
        if (name.contains(".")) {
            classNames.add(name);
        } else {
            this.getNativeJavaPackages().forEach(entry -> classNames.add(entry + name));
        }
        return classNames;
    }

    private Set<Class<?>> loadClasses(List<String> classNames) {
        HashSet classes = new HashSet();
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception e) {
                try {
                    classes.add(MockClassLoader.getInstance().loadClass(className));
                }
                catch (Exception exception) {}
            }
        }
        return classes;
    }

    private List<String> getNativeJavaPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        Path path = new File("src/main/resources/java.packages.txt").toPath();
        try (Stream<String> lines = Files.lines(path);){
            lines.forEach(line -> packages.add(line + "."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packages;
    }

    private ModifierEnum[] getModifiers(MethodDeclaration md) {
        return (ModifierEnum[])md.getModifiers().stream().map(mod -> {
            try {
                return ModifierEnum.valueOf(mod.name());
            }
            catch (Exception e) {
                return null;
            }
        }).toArray(ModifierEnum[]::new);
    }

    private VisibilityEnum getVisibility(MethodDeclaration md) {
        VisibilityEnum visibilityEnum = md.isProtected() ? VisibilityEnum.PROTECTED : (md.isPrivate() ? VisibilityEnum.PRIVATE : VisibilityEnum.PUBLIC);
        return visibilityEnum;
    }
}

