/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock.parse;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.esfinge.classmock.MockClassLoader;
import net.sf.esfinge.classmock.api.IAnnotationReader;
import net.sf.esfinge.classmock.api.enums.LocationEnum;
import net.sf.esfinge.classmock.api.enums.ModifierEnum;
import net.sf.esfinge.classmock.api.enums.VisibilityEnum;
import net.sf.esfinge.classmock.imp.AnnotationImp;
import net.sf.esfinge.classmock.imp.FieldImp;

public final class ParseFieldSignature {
    private static ParseFieldSignature instance = new ParseFieldSignature();

    private ParseFieldSignature() {
    }

    public static ParseFieldSignature getInstance() {
        return instance;
    }

    public FieldImp parse(String signature) {
        StringBuilder sb = new StringBuilder();
        sb.append("class A {\n");
        sb.append(signature.endsWith(";") ? signature : signature.concat(";"));
        sb.append("\n}");
        FieldImp field = new FieldImp("NOT_DEFINED", null);
        CompilationUnit compilationUnit = JavaParser.parse((String)sb.toString());
        compilationUnit.getClassByName("A").ifPresent(clazz -> clazz.getFields().forEach(fd -> {
            field.name(((VariableDeclarator)fd.getVariables().get(0)).toString());
            field.type(this.getType((FieldDeclaration)fd));
            field.visibility(this.getVisibility((FieldDeclaration)fd));
            field.modifiers(this.getModifiers((FieldDeclaration)fd));
            fd.getAnnotations().forEach(an -> this.getAnnotationField((AnnotationExpr)an).ifPresent(x -> field.annotation((IAnnotationReader)x)));
        }));
        return field;
    }

    private Class<?> getType(FieldDeclaration fd) {
        String type = ((VariableDeclarator)fd.getVariables().get(0)).getType().asString();
        ArrayList<String> classNames = new ArrayList<String>();
        if (type.contains(".")) {
            classNames.add(type.trim());
        } else {
            this.getNativeJavaPackages().forEach(p -> classNames.add(p + type.trim()));
        }
        List classes = this.loadClasses(classNames).stream().collect(Collectors.toList());
        return classes.isEmpty() ? Object.class : (Class)classes.get(0);
    }

    private Optional<AnnotationImp> getAnnotationField(AnnotationExpr an) {
        Optional<AnnotationImp> optional = Optional.empty();
        List<String> classes = this.findImportForClasses(an.getNameAsString());
        for (Class<?> clazz : this.loadClasses(classes)) {
            try {
                AnnotationImp annotationImp = new AnnotationImp(clazz.asSubclass(Annotation.class));
                annotationImp.location(LocationEnum.FIELD);
                an.ifNormalAnnotationExpr(normal -> normal.getPairs().forEach(pair -> annotationImp.property(pair.getNameAsString(), pair.getValue().toString().replaceAll("\"", ""))));
                optional = Optional.ofNullable(annotationImp);
                break;
            }
            catch (Exception exception) {
            }
        }
        return optional;
    }

    private List<String> findImportForClasses(String name) {
        ArrayList<String> classNames = new ArrayList<String>();
        if (name.contains(".")) {
            classNames.add(name);
        } else {
            this.getNativeJavaPackages().forEach(entry -> classNames.add(entry + name));
        }
        return classNames;
    }

    private Set<Class<?>> loadClasses(List<String> classNames) {
        HashSet classes = new HashSet();
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception e) {
                try {
                    classes.add(MockClassLoader.getInstance().loadClass(className));
                }
                catch (Exception exception) {}
            }
        }
        return classes;
    }

    private List<String> getNativeJavaPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        Path path = new File("src/main/resources/java.packages.txt").toPath();
        try (Stream<String> lines = Files.lines(path);){
            lines.forEach(line -> packages.add(line + "."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packages;
    }

    private ModifierEnum[] getModifiers(FieldDeclaration fd) {
        return (ModifierEnum[])fd.getModifiers().stream().map(mod -> {
            try {
                return ModifierEnum.valueOf(mod.name());
            }
            catch (Exception e) {
                return null;
            }
        }).toArray(ModifierEnum[]::new);
    }

    private VisibilityEnum getVisibility(FieldDeclaration fd) {
        VisibilityEnum visibilityEnum = fd.isProtected() ? VisibilityEnum.PROTECTED : (fd.isPublic() ? VisibilityEnum.PUBLIC : VisibilityEnum.PRIVATE);
        return visibilityEnum;
    }
}

