/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock.imp;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.sf.esfinge.classmock.api.IAnnotationPropertyWriter;
import net.sf.esfinge.classmock.api.IAnnotationReader;
import net.sf.esfinge.classmock.api.IFieldReader;
import net.sf.esfinge.classmock.api.IFieldWriter;
import net.sf.esfinge.classmock.api.IMethodReader;
import net.sf.esfinge.classmock.api.IMethodWriter;
import net.sf.esfinge.classmock.api.enums.LocationEnum;
import net.sf.esfinge.classmock.api.enums.ModifierEnum;
import net.sf.esfinge.classmock.api.enums.VisibilityEnum;
import net.sf.esfinge.classmock.imp.AnnotationImp;
import net.sf.esfinge.classmock.imp.FieldImp;

public class MethodImp
implements IMethodReader,
IMethodWriter,
Comparable<MethodImp> {
    private String name;
    private Object value;
    private Class<?> returnType = Void.TYPE;
    private VisibilityEnum visibility = VisibilityEnum.PUBLIC;
    private final Set<ModifierEnum> modifiers = new HashSet<ModifierEnum>();
    private final Set<Class<?>> exceptions = new HashSet();
    private final Set<IFieldReader> parameters = new TreeSet<IFieldReader>();
    private final Set<IAnnotationReader> annotations = new HashSet<IAnnotationReader>();

    public MethodImp(String name) {
        this.name = name;
    }

    public MethodImp(IMethodReader method) {
        this.name = method.name();
        this.returnType = method.returnType();
        this.visibility = method.visibility();
        this.modifiers.addAll(method.modifiers());
        this.exceptions.addAll(method.exceptions());
        this.parameters.addAll(method.parameters());
        this.annotations.addAll(method.annotations());
    }

    @Override
    public IMethodWriter name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public IMethodWriter returnTypeAsVoid() {
        return this.returnType(Void.TYPE);
    }

    @Override
    public IMethodWriter returnType(Class<?> clazz) {
        this.returnType = clazz;
        return this;
    }

    @Override
    public IFieldWriter parameter(String name, Class<?> type) {
        FieldImp wrapper = new FieldImp(name, type);
        this.parameters.add(wrapper);
        return wrapper;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> returnType() {
        return this.returnType;
    }

    @Override
    public Collection<IFieldReader> parameters() {
        return this.parameters;
    }

    @Override
    public IMethodWriter modifiers(ModifierEnum ... modifiers) {
        this.modifiers.addAll(Arrays.asList(modifiers));
        return this;
    }

    @Override
    public Collection<ModifierEnum> modifiers() {
        return this.modifiers;
    }

    @Override
    public IMethodWriter visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @Override
    public VisibilityEnum visibility() {
        return this.visibility;
    }

    @Override
    public IAnnotationPropertyWriter annotation(Class<? extends Annotation> annotation) {
        return this.annotation(annotation, LocationEnum.METHOD);
    }

    @Override
    public IAnnotationPropertyWriter annotation(Class<? extends Annotation> annotation, LocationEnum location) {
        AnnotationImp wrapper = new AnnotationImp(annotation);
        wrapper.location(location);
        return this.annotation(wrapper);
    }

    @Override
    public IAnnotationPropertyWriter annotation(IAnnotationReader annotation) {
        AnnotationImp wrapper = new AnnotationImp(annotation);
        wrapper.setAnd(this);
        this.annotations.add(wrapper);
        return wrapper;
    }

    @Override
    public Collection<IAnnotationReader> annotations() {
        return this.annotations;
    }

    @Override
    public IMethodWriter exceptions(Class<?> ... exceptions) {
        this.exceptions.addAll(Arrays.asList(exceptions));
        return this;
    }

    @Override
    public Collection<Class<?>> exceptions() {
        return this.exceptions;
    }

    @Override
    public IMethodWriter value(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public int compareTo(MethodImp other) {
        return this.name().compareTo(other.name());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodImp other = (MethodImp)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    public String toString() {
        return this.name;
    }
}

