/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.esfinge.classmock.api.IAnnotationLocationReader;
import net.sf.esfinge.classmock.api.IAnnotationReader;
import net.sf.esfinge.classmock.api.IClassReader;
import net.sf.esfinge.classmock.api.IFieldReader;
import net.sf.esfinge.classmock.api.IMethodReader;
import net.sf.esfinge.classmock.api.enums.LocationEnum;
import net.sf.esfinge.classmock.api.enums.ModifierEnum;
import net.sf.esfinge.classmock.api.enums.VisibilityEnum;
import net.sf.esfinge.classmock.imp.AnnotationImp;
import net.sf.esfinge.classmock.imp.FieldImp;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

class ParseASM {
    private static final String ENUM_VALUES = "ENUM$VALUES";
    private final IClassReader reader;
    private final boolean visibleAtRuntime = true;
    private final ClassWriter cw = new ClassWriter(2);

    public ParseASM(IClassReader reader) {
        this.reader = reader;
    }

    public byte[] parse() {
        this.addEntity();
        this.addClassDefaultConstructor();
        this.addClassLevelAnnotations();
        this.addFields();
        this.addMethods();
        this.cw.visitEnd();
        return this.cw.toByteArray();
    }

    private void addEnumFieldValues() {
        FieldImp field = new FieldImp(ENUM_VALUES, Enum.class);
        field.visibility(VisibilityEnum.PRIVATE);
        field.modifiers(ModifierEnum.FINAL, ModifierEnum.STATIC, ModifierEnum.SYNTHETIC);
        field.hasGetter(false);
        field.hasSetter(false);
        this.reader.fields().add(field);
    }

    private void addClassDefaultConstructor() {
        if (this.reader.isClass() || this.reader.isAbstract()) {
            MethodVisitor mv = this.cw.visitMethod(VisibilityEnum.PUBLIC.getOpCodes(), "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.getInternalName(this.reader.superclass().superclass()), "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }

    private void addEntity() {
        int opcodes = this.reader.visibility().getOpCodes() + this.reader.modifiers().stream().mapToInt(m -> m.getOpCodes()).sum();
        this.cw.visit(this.reader.version().getOpCodes(), opcodes, this.getEntityName(), this.addGenericSuperClassSignature(), this.getInternalName(this.reader.superclass().superclass()), (String[])this.reader.interfaces().stream().map(i -> this.getInternalName((Class<?>)i)).toArray(String[]::new));
    }

    private String getEntityName() {
        return this.reader.name().contains(".") ? this.reader.name().replaceAll("\\.", "/") : this.reader.name();
    }

    private String getEntityEnumName() {
        return "L" + this.getEntityName() + ";";
    }

    private String getEntityEnumNameArray() {
        return "[" + this.getEntityEnumName();
    }

    private void addClassLevelAnnotations() {
        ClassWriter cv = this.cw;
        for (IAnnotationReader wrapper : this.reader.annotations()) {
            AnnotationVisitor av = cv.visitAnnotation(this.getDescriptor(wrapper), this.visibleAtRuntime);
            this.createAnnotation(av, wrapper);
        }
    }

    private void addFields() {
        if (this.reader.isEnum()) {
            this.addEnumFieldValues();
        }
        for (IFieldReader field : this.reader.fields()) {
            FieldVisitor fv = this.toFieldVisitor(field);
            for (IAnnotationReader wrapper : field.annotations()) {
                if (wrapper instanceof IAnnotationLocationReader) {
                    IAnnotationLocationReader location = (IAnnotationLocationReader)((Object)wrapper);
                    if (location.location() != null && location.location() != LocationEnum.FIELD) continue;
                    this.createAnnotation(fv, wrapper);
                    continue;
                }
                this.createAnnotation(fv, wrapper);
            }
            fv.visitEnd();
            if (field.hasGetter()) {
                this.createGetter(field);
            }
            if (!field.hasSetter()) continue;
            this.createSetter(field);
        }
    }

    private void addMethods() {
        if (this.reader.isEnum()) {
            this.createClinitEnum();
            this.createInitEnum();
            this.createValuesEnum();
            this.createValueOfEnum();
        }
        for (IMethodReader method : this.reader.methods()) {
            int parameterPosition = 0;
            int opcodes = method.visibility().getOpCodes() + method.modifiers().stream().mapToInt(m -> m.getOpCodes()).sum();
            MethodVisitor mv = this.cw.visitMethod(opcodes, method.name(), this.getMethodSignature(method), null, method.exceptions().isEmpty() ? null : (String[])method.exceptions().stream().map(clazz -> this.getInternalName((Class<?>)clazz)).toArray(String[]::new));
            for (IAnnotationReader wrapper : method.annotations()) {
                this.createAnnotation(mv, wrapper);
            }
            for (IFieldReader parameter : method.parameters()) {
                for (IAnnotationReader wrapper : parameter.annotations()) {
                    this.createAnnotation(mv, wrapper, parameterPosition);
                }
                ++parameterPosition;
            }
            mv.visitCode();
            if (!this.reader.isInterface() && !this.reader.isAnnotation()) {
                if (method.returnType() == Void.TYPE) {
                    mv.visitInsn(177);
                    mv.visitMaxs(0, 1);
                } else if (Arrays.asList(Integer.TYPE, Short.TYPE, Byte.TYPE, Character.TYPE, Boolean.TYPE).contains(method.returnType())) {
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                    mv.visitMaxs(1, 1);
                } else if (method.returnType() == Long.TYPE) {
                    mv.visitInsn(9);
                    mv.visitInsn(173);
                    mv.visitMaxs(2, 1);
                } else if (method.returnType() == Float.TYPE) {
                    mv.visitInsn(11);
                    mv.visitInsn(174);
                    mv.visitMaxs(1, 1);
                } else if (method.returnType() == Double.TYPE) {
                    mv.visitInsn(14);
                    mv.visitInsn(175);
                    mv.visitMaxs(2, 1);
                } else {
                    mv.visitInsn(1);
                    mv.visitInsn(176);
                    mv.visitMaxs(1, 1);
                }
                mv.visitEnd();
                continue;
            }
            if (!this.reader.isAnnotation() || method.value() == null) continue;
            AnnotationVisitor av = mv.visitAnnotationDefault();
            av.visit(null, method.value());
            av.visitEnd();
            mv.visitEnd();
        }
    }

    private void createClinitEnum() {
        MethodVisitor mv = this.cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        int counter = 0;
        int[] array = new int[]{3, 4, 5, 6, 7, 8};
        List fields = this.reader.fields().stream().filter(f -> this.isConstantEnum((IFieldReader)f) || this.isDefaultFieldEnumValues((IFieldReader)f)).collect(Collectors.toList());
        for (IFieldReader field : fields) {
            if (this.isDefaultFieldEnumValues(field)) continue;
            mv.visitTypeInsn(187, this.getEntityName());
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)field.name());
            if (counter < array.length) {
                mv.visitInsn(array[counter++]);
            } else {
                mv.visitIntInsn(16, counter++);
            }
            mv.visitMethodInsn(183, this.getEntityName(), "<init>", "(Ljava/lang/String;I)V", false);
            mv.visitFieldInsn(179, this.getEntityName(), field.name(), this.getEntityEnumName());
        }
        boolean isFistTime = true;
        for (IFieldReader field : fields) {
            if (this.isDefaultFieldEnumValues(field)) {
                if (isFistTime) {
                    isFistTime = false;
                    mv.visitInsn(3);
                    mv.visitTypeInsn(189, this.getEntityName());
                    mv.visitFieldInsn(179, this.getEntityName(), field.name(), this.getEntityEnumNameArray());
                    mv.visitInsn(177);
                    mv.visitMaxs(1, 0);
                    mv.visitEnd();
                    continue;
                }
                mv.visitInsn(83);
                mv.visitFieldInsn(179, this.getEntityName(), field.name(), this.getEntityEnumNameArray());
                mv.visitInsn(177);
                mv.visitMaxs(4, 0);
                mv.visitEnd();
                continue;
            }
            if (isFistTime) {
                isFistTime = false;
                mv.visitIntInsn(16, counter);
                counter = 0;
                mv.visitTypeInsn(189, this.getEntityName());
                mv.visitInsn(89);
                mv.visitInsn(array[counter++]);
                mv.visitFieldInsn(178, this.getEntityName(), field.name(), this.getEntityEnumName());
                continue;
            }
            if (counter < array.length) {
                mv.visitInsn(83);
                mv.visitInsn(89);
                mv.visitInsn(array[counter++]);
                mv.visitFieldInsn(178, this.getEntityName(), field.name(), this.getEntityEnumName());
                continue;
            }
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitIntInsn(16, counter++);
            mv.visitFieldInsn(178, this.getEntityName(), field.name(), this.getEntityEnumName());
        }
    }

    private void createInitEnum() {
        MethodVisitor mv = this.cw.visitMethod(VisibilityEnum.PRIVATE.getOpCodes(), "<init>", "(Ljava/lang/String;I)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(3, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V", false);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", this.getEntityEnumName(), null, l0, l1, 0);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private void createValuesEnum() {
        int opcodes = VisibilityEnum.PUBLIC.getOpCodes() + ModifierEnum.STATIC.getOpCodes();
        MethodVisitor mv = this.cw.visitMethod(opcodes, "values", "()" + this.getEntityEnumNameArray(), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(1, l0);
        mv.visitFieldInsn(178, this.getEntityName(), ENUM_VALUES, this.getEntityEnumNameArray());
        mv.visitInsn(89);
        mv.visitVarInsn(58, 0);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(190);
        mv.visitInsn(89);
        mv.visitVarInsn(54, 1);
        mv.visitTypeInsn(189, this.getEntityName());
        mv.visitInsn(89);
        mv.visitVarInsn(58, 2);
        mv.visitInsn(3);
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(5, 3);
        mv.visitEnd();
    }

    private void createValueOfEnum() {
        int opcodes = VisibilityEnum.PUBLIC.getOpCodes() + ModifierEnum.STATIC.getOpCodes();
        MethodVisitor mv = this.cw.visitMethod(opcodes, "valueOf", "(Ljava/lang/String;)" + this.getEntityEnumName(), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(1, l0);
        mv.visitLdcInsn((Object)Type.getType((String)this.getEntityEnumName()));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.getEntityName());
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void createGetter(IFieldReader field) {
        String typeDescriptor = this.getDescriptor(field.type());
        String typeGenericDescriptor = this.getDescriptor(field.generics());
        MethodVisitor mv = this.cw.visitMethod(VisibilityEnum.PUBLIC.getOpCodes(), this.getGetterName(field), "()" + typeDescriptor, typeGenericDescriptor, null);
        for (IAnnotationReader wrapper : field.annotations()) {
            if (!(wrapper instanceof IAnnotationLocationReader) || ((IAnnotationLocationReader)((Object)wrapper)).location() != LocationEnum.GETTER) continue;
            this.createAnnotation(mv, wrapper);
        }
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getEntityName(), field.name(), typeDescriptor);
        if (Arrays.asList("I", "B", "Z", "C", "S").contains(typeDescriptor)) {
            mv.visitInsn(172);
        } else if ("J".equals(typeDescriptor)) {
            mv.visitInsn(173);
        } else if ("F".equals(typeDescriptor)) {
            mv.visitInsn(174);
        } else if ("D".equals(typeDescriptor)) {
            mv.visitInsn(175);
        } else {
            mv.visitInsn(176);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void createSetter(IFieldReader field) {
        String typeDescriptor = this.getDescriptor(field.type());
        String typeGenericDescriptor = this.getDescriptor(field.generics());
        MethodVisitor mv = this.cw.visitMethod(VisibilityEnum.PUBLIC.getOpCodes(), this.getSetterName(field), "(" + typeDescriptor + ")V", typeGenericDescriptor, null);
        for (IAnnotationReader wrapper : field.annotations()) {
            if (!(wrapper instanceof IAnnotationLocationReader) || ((IAnnotationLocationReader)((Object)wrapper)).location() != LocationEnum.SETTER) continue;
            this.createAnnotation(mv, wrapper);
        }
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (Arrays.asList("I", "B", "Z", "C", "S").contains(typeDescriptor)) {
            mv.visitVarInsn(21, 1);
        } else if ("J".equals(typeDescriptor)) {
            mv.visitVarInsn(22, 1);
        } else if ("F".equals(typeDescriptor)) {
            mv.visitVarInsn(23, 1);
        } else if ("D".equals(typeDescriptor)) {
            mv.visitVarInsn(24, 1);
        } else {
            mv.visitVarInsn(25, 1);
        }
        mv.visitFieldInsn(181, this.getEntityName(), field.name(), typeDescriptor);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void createAnnotation(MethodVisitor mv, IAnnotationReader wrapper, int parameterPosition) {
        AnnotationVisitor av = mv.visitParameterAnnotation(parameterPosition, this.getDescriptor(wrapper), this.visibleAtRuntime);
        this.createAnnotation(av, wrapper);
    }

    private void createAnnotation(MethodVisitor mv, IAnnotationReader wrapper) {
        AnnotationVisitor av = mv.visitAnnotation(this.getDescriptor(wrapper), this.visibleAtRuntime);
        this.createAnnotation(av, wrapper);
    }

    private void createAnnotation(FieldVisitor fv, IAnnotationReader wrapper) {
        AnnotationVisitor av = fv.visitAnnotation(this.getDescriptor(wrapper), this.visibleAtRuntime);
        this.createAnnotation(av, wrapper);
    }

    private void createAnnotation(AnnotationVisitor av, IAnnotationReader wrapper) {
        for (Map.Entry<String, Object> entry : wrapper.properties().entrySet()) {
            String propName = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Class) {
                av.visit(propName, (Object)Type.getType((Class)((Class)value)));
                continue;
            }
            if (value.getClass().isArray()) {
                boolean isAnnotationArray = value.getClass().getComponentType() == IAnnotationReader.class;
                AnnotationVisitor avArray = av.visitArray(propName);
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (isAnnotationArray) {
                        IAnnotationReader innerWrapper = (IAnnotationReader)Array.get(value, i);
                        AnnotationVisitor innerAV = avArray.visitAnnotation(null, this.getDescriptor(innerWrapper));
                        this.createAnnotation(innerAV, innerWrapper);
                        continue;
                    }
                    Optional<IAnnotationReader> optional = this.toAnnotationWrapper(Array.get(value, i));
                    if (optional.isPresent()) {
                        IAnnotationReader innerWrapper = optional.get();
                        AnnotationVisitor innerAV = avArray.visitAnnotation(null, this.getDescriptor(innerWrapper));
                        this.createAnnotation(innerAV, innerWrapper);
                        continue;
                    }
                    avArray.visit(null, Array.get(value, i));
                }
                avArray.visitEnd();
                continue;
            }
            if (value.getClass().isEnum()) {
                av.visitEnum(propName, this.getDescriptor(value.getClass()), value.toString());
                continue;
            }
            if (IAnnotationReader.class.isAssignableFrom(value.getClass())) {
                IAnnotationReader innerWrapper = (IAnnotationReader)value;
                AnnotationVisitor innerAV = av.visitAnnotation(propName, this.getDescriptor(innerWrapper));
                this.createAnnotation(innerAV, innerWrapper);
                continue;
            }
            av.visit(propName, value);
        }
        av.visitEnd();
    }

    private FieldVisitor toFieldVisitor(IFieldReader field) {
        FieldVisitor fv = null;
        int opcodes = field.visibility().getOpCodes() + field.modifiers().stream().mapToInt(m -> m.getOpCodes()).sum();
        fv = this.reader.isEnum() && field.modifiers().contains((Object)ModifierEnum.STATIC) ? (this.isDefaultFieldEnumValues(field) ? this.cw.visitField(opcodes, field.name(), this.getEntityEnumNameArray(), null, null) : this.cw.visitField(opcodes, field.name(), this.getEntityEnumName(), null, null)) : this.cw.visitField(opcodes, field.name(), this.getDescriptor(field.type()), this.getDescriptor(field.generics()), field.value());
        return fv;
    }

    private Optional<IAnnotationReader> toAnnotationWrapper(Object innerAnnotation) {
        Optional<IAnnotationReader> optional = Optional.empty();
        try {
            String canonicalName = innerAnnotation.getClass().getCanonicalName();
            canonicalName = canonicalName.contains("$") ? canonicalName.split("\\$")[1].trim() : canonicalName;
            Class<?> clazz = Class.forName(canonicalName);
            AnnotationImp wrapper = new AnnotationImp(clazz);
            for (Method method : clazz.getDeclaredMethods()) {
                Method realMethod = innerAnnotation.getClass().getMethod(method.getName(), new Class[0]);
                Object value = realMethod.invoke(innerAnnotation, new Object[0]);
                if (value == null) continue;
                wrapper.properties().put(method.getName(), value);
            }
            optional = Optional.ofNullable(wrapper);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return optional;
    }

    private String addGenericSuperClassSignature() {
        String signature = null;
        Class<?> superclass = this.reader.superclass().superclass();
        Collection<Class<?>> generics = this.reader.superclass().generics();
        if (superclass != null && !generics.isEmpty()) {
            SignatureVisitor sv = new SignatureWriter().visitClassBound();
            SignatureVisitor svsc = sv.visitSuperclass();
            svsc.visitClassType(this.getInternalName(superclass));
            generics.forEach(generic -> {
                SignatureVisitor svpt = svsc.visitTypeArgument('=');
                svpt.visitClassType(this.getInternalName((Class<?>)generic));
                svpt.visitEnd();
            });
            svsc.visitEnd();
            sv.visitEnd();
            signature = sv.toString();
        }
        return signature;
    }

    private String getMethodSignature(IMethodReader method) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (IFieldReader field : method.parameters()) {
            sb.append(this.getDescriptor(field.type()));
        }
        sb.append(")");
        sb.append(this.getDescriptor(method.returnType()));
        return sb.toString();
    }

    private String getGetterName(IFieldReader field) {
        String name = field.name();
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String getSetterName(IFieldReader field) {
        String name = field.name();
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String getInternalName(Class<?> clazz) {
        return clazz != null ? Type.getInternalName(clazz) : null;
    }

    private String getDescriptor(Class<?> clazz) {
        return clazz != null ? Type.getDescriptor(clazz) : null;
    }

    private String getDescriptor(IAnnotationReader wrapper) {
        return wrapper != null ? Type.getDescriptor(wrapper.annotation()) : null;
    }

    private boolean isConstantEnum(IFieldReader field) {
        return VisibilityEnum.PUBLIC.equals((Object)field.visibility()) && field.modifiers().contains((Object)ModifierEnum.FINAL) && field.modifiers().contains((Object)ModifierEnum.STATIC) && field.modifiers().contains((Object)ModifierEnum.ENUM);
    }

    private boolean isDefaultFieldEnumValues(IFieldReader field) {
        return ENUM_VALUES.equals(field.name());
    }
}

