/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.classmock.AbstractMethod;
import net.sf.esfinge.classmock.Annotation;
import net.sf.esfinge.classmock.Location;
import net.sf.esfinge.classmock.Method;
import net.sf.esfinge.classmock.MockClassLoader;
import net.sf.esfinge.classmock.Property;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassMock {
    private static Map<String, Integer> cache = new HashMap<String, Integer>();
    private String name;
    private String realName;
    private boolean isInterface = false;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<Class, Annotation> annotations = new HashMap<Class, Annotation>();
    private Set<AbstractMethod> methods = new HashSet<AbstractMethod>();
    private Class superclass = Object.class;
    private List<Class> interfaces = new ArrayList<Class>();
    private Class cacheClass;

    public ClassMock(String name) {
        this.name = name;
    }

    public ClassMock(String name, boolean isInterface) {
        this.name = name;
        this.isInterface = isInterface;
    }

    private String getClassName() {
        if (this.realName != null) {
            return this.realName;
        }
        if (cache.containsKey(this.name)) {
            cache.put(this.name, cache.get(this.name) + 1);
            return this.name + "_" + cache.get(this.name);
        }
        cache.put(this.name, 1);
        return this.name + "_1";
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public ClassMock addProperty(String name, Class type) {
        Property prop = new Property(type, name, true, true);
        this.properties.put(name, prop);
        return this;
    }

    public ClassMock addPropertyReadOnly(String name, Class type) {
        Property prop = new Property(type, name, false, true);
        this.properties.put(name, prop);
        return this;
    }

    public ClassMock addProperty(String name, Class type, boolean hasSetter, boolean hasGetter) {
        Property prop = new Property(type, name, hasSetter, hasGetter);
        this.properties.put(name, prop);
        return this;
    }

    public ClassMock addAnnotation(String property, Annotation annotation) {
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotation(String property, Class annotationClass) {
        Annotation annotation = new Annotation(annotationClass);
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotation(String property, Class annotationClass, Location location) {
        Annotation annotation = new Annotation(annotationClass, location);
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotation(String property, Class annotationClass, Location location, Object value) {
        Annotation annotation = new Annotation(annotationClass, location);
        annotation.addProperty("value", value);
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotation(String property, Class annotationClass, Object value) {
        Annotation annotation = new Annotation(annotationClass);
        annotation.addProperty("value", value);
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotation(String property, Class annotationClass, String annotationProperty, Object value) {
        Annotation annotation = new Annotation(annotationClass);
        annotation.addProperty(annotationProperty, value);
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotation(String property, Class annotationClass, Location location, String annotationProperty, Object value) {
        Annotation annotation = new Annotation(annotationClass, location);
        annotation.addProperty(annotationProperty, value);
        this.properties.get(property).addAnnotation(annotation);
        return this;
    }

    public ClassMock addAnnotationProperty(String property, Class annotationClass, String annotationProperty, Object value) {
        this.properties.get(property).addAnnotationProperty(annotationClass, annotationProperty, value);
        return this;
    }

    public ClassMock addAnnotationProperty(String property, Class annotationClass, Object value) {
        this.properties.get(property).addAnnotationProperty(annotationClass, "value", value);
        return this;
    }

    public ClassMock addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.getAnnotation(), annotation);
        return this;
    }

    public ClassMock addAnnotation(Class annotationClass) {
        Annotation annotation = new Annotation(annotationClass);
        this.annotations.put(annotation.getAnnotation(), annotation);
        return this;
    }

    public ClassMock addAnnotation(Class annotationClass, Object value) {
        Annotation annotation = new Annotation(annotationClass);
        annotation.addProperty("value", value);
        this.annotations.put(annotation.getAnnotation(), annotation);
        return this;
    }

    public ClassMock addAnnotation(Class annotationClass, String annotationProperty, Object value) {
        Annotation annotation = new Annotation(annotationClass);
        annotation.addProperty(annotationProperty, value);
        this.annotations.put(annotation.getAnnotation(), annotation);
        return this;
    }

    public ClassMock addAnnotationProperty(Class annotationClass, String annotationProperty, Object value) {
        this.annotations.get(annotationClass).addProperty(annotationProperty, value);
        return this;
    }

    public ClassMock addAnnotationProperty(Class annotationClass, Object value) {
        this.annotations.get(annotationClass).addProperty("value", value);
        return this;
    }

    public ClassMock addAbstractMethod(Class returnType, String name, Class ... params) {
        this.methods.add(new AbstractMethod(name, returnType, params));
        return this;
    }

    public ClassMock addMethod(Class returnType, String name, Class ... params) {
        this.methods.add(new Method(name, returnType, params));
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Annotation an) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName)) continue;
            am.addAnnotation(an);
        }
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Annotation an, Class ... params) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName) || !Arrays.equals(am.getParameters(), params)) continue;
            am.addAnnotation(an);
        }
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Class anClass) {
        Annotation an = new Annotation(anClass);
        this.addMethodAnnotation(methodName, an);
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Class anClass, Object value) {
        Annotation an = new Annotation(anClass, value);
        this.addMethodAnnotation(methodName, an);
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Class anClass, String property, Object value) {
        Annotation an = new Annotation(anClass, property, value);
        this.addMethodAnnotation(methodName, an);
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Class anClass, Class ... params) {
        Annotation an = new Annotation(anClass);
        this.addMethodAnnotation(methodName, an, params);
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Class anClass, Object value, Class ... params) {
        Annotation an = new Annotation(anClass, value);
        this.addMethodAnnotation(methodName, an, params);
        return this;
    }

    public ClassMock addMethodAnnotation(String methodName, Class anClass, String property, Object value, Class ... params) {
        Annotation an = new Annotation(anClass, property, value);
        this.addMethodAnnotation(methodName, an, params);
        return this;
    }

    public ClassMock addMethodAnnotationProperty(String methodName, Class anClass, String property, Object value, Class ... params) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName) || !Arrays.equals(am.getParameters(), params)) continue;
            am.getAnnotation(anClass).addProperty(property, value);
        }
        return this;
    }

    public ClassMock addMethodAnnotationProperty(String methodName, Class anClass, String property, Object value) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName)) continue;
            am.getAnnotation(anClass).addProperty(property, value);
        }
        return this;
    }

    public ClassMock addMethodParamAnnotationProperty(int param, String methodName, Class anClass, String property, Object value, Class ... params) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName) || !Arrays.equals(am.getParameters(), params)) continue;
            am.getParamAnnotation(param, anClass).addProperty(property, value);
        }
        return this;
    }

    public ClassMock addMethodParamAnnotationProperty(int param, String methodName, Class anClass, String property, Object value) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName)) continue;
            am.getParamAnnotation(param, anClass).addProperty(property, value);
        }
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Annotation an) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName)) continue;
            am.addParamAnnotation(param, an);
        }
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Annotation an, Class ... params) {
        for (AbstractMethod am : this.methods) {
            if (!am.getName().equals(methodName) || !Arrays.equals(am.getParameters(), params)) continue;
            am.addParamAnnotation(param, an);
        }
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Class anClass) {
        Annotation an = new Annotation(anClass);
        this.addMethodParamAnnotation(param, methodName, an);
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Class anClass, Object value) {
        Annotation an = new Annotation(anClass, value);
        this.addMethodParamAnnotation(param, methodName, an);
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Class anClass, String property, Object value) {
        Annotation an = new Annotation(anClass, property, value);
        this.addMethodParamAnnotation(param, methodName, an);
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Class anClass, Class ... params) {
        Annotation an = new Annotation(anClass);
        this.addMethodParamAnnotation(param, methodName, an, params);
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Class anClass, Object value, Class ... params) {
        Annotation an = new Annotation(anClass, value);
        this.addMethodParamAnnotation(param, methodName, an, params);
        return this;
    }

    public ClassMock addMethodParamAnnotation(int param, String methodName, Class anClass, String property, Object value, Class ... params) {
        Annotation an = new Annotation(anClass, property, value);
        this.addMethodParamAnnotation(param, methodName, an, params);
        return this;
    }

    public Class getSuperclass() {
        return this.superclass;
    }

    public ClassMock setSuperclass(Class superclass) {
        this.superclass = superclass;
        return this;
    }

    public List<Class> getInterfaces() {
        return this.interfaces;
    }

    public ClassMock addInterface(Class interf) {
        if (!interf.isInterface()) {
            throw new IllegalArgumentException("The parameter must be an interface");
        }
        this.interfaces.add(interf);
        return this;
    }

    private String[] getInterfacesNames() {
        String[] inames = new String[this.interfaces.size()];
        for (int i = 0; i < inames.length; ++i) {
            inames[i] = Type.getType((Class)this.interfaces.get(i)).getInternalName();
        }
        return inames;
    }

    private boolean isAbstract() {
        for (AbstractMethod m : this.methods) {
            if (!m.isAbstract()) continue;
            return true;
        }
        if (Modifier.isAbstract(this.superclass.getModifiers())) {
            return true;
        }
        for (Class interf : this.interfaces) {
            if (interf.getMethods().length <= 0) continue;
            return true;
        }
        return false;
    }

    public Class createClass() {
        if (this.cacheClass != null) {
            return this.cacheClass;
        }
        ClassWriter cw = new ClassWriter(2);
        String[] interfaceNames = null;
        if (this.interfaces.size() > 0) {
            interfaceNames = this.getInterfacesNames();
        }
        String name = this.getClassName();
        if (this.isInterface) {
            cw.visit(49, 1537, name, null, "java/lang/Object", interfaceNames);
        } else {
            int modificadores = 33;
            if (this.isAbstract()) {
                modificadores += 1024;
            }
            cw.visit(49, modificadores, name, null, Type.getType((Class)this.superclass).getInternalName(), interfaceNames);
        }
        for (Annotation an : this.annotations.values()) {
            an.createAnnotation((ClassVisitor)cw);
        }
        if (!this.isInterface) {
            this.createConstructor(cw);
            for (Property prop : this.properties.values()) {
                prop.createProperty(cw, name);
            }
        }
        for (AbstractMethod ab : this.methods) {
            ab.createMethod(cw);
        }
        cw.visitEnd();
        MockClassLoader cl = MockClassLoader.getInstance();
        this.cacheClass = cl.defineClass(name, cw.toByteArray());
        return this.cacheClass;
    }

    private void createConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getType((Class)this.superclass).getInternalName(), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }
}

