/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.web.AlreadyCommittedException;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import net.sf.ehcache.constructs.web.ResponseUtil;
import net.sf.ehcache.constructs.web.SerializableCookie;
import net.sf.ehcache.constructs.web.filter.Filter;
import net.sf.ehcache.constructs.web.filter.FilterNonReentrantException;

public abstract class CachingFilter
extends Filter {
    private static final Logger LOG = Logger.getLogger(CachingFilter.class.getName());
    private static final String BLOCKING_TIMEOUT_MILLIS = "blockingTimeoutMillis";
    private static final String CACHE_NAME = "cacheName";
    protected String cacheName;
    protected BlockingCache blockingCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInit(FilterConfig filterConfig) throws CacheException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.blockingCache == null) {
                this.setCacheNameIfAnyConfigured(filterConfig);
                String localCacheName = this.getCacheName();
                Ehcache cache = this.getCacheManager().getEhcache(localCacheName);
                if (!(cache instanceof BlockingCache)) {
                    BlockingCache newBlockingCache = new BlockingCache(cache);
                    this.getCacheManager().replaceCacheWithDecoratedCache(cache, (Ehcache)newBlockingCache);
                }
                this.blockingCache = (BlockingCache)this.getCacheManager().getEhcache(localCacheName);
                Integer blockingTimeoutMillis = this.parseBlockingCacheTimeoutMillis(filterConfig);
                if (blockingTimeoutMillis != null && blockingTimeoutMillis > 0) {
                    this.blockingCache.setTimeoutMillis(blockingTimeoutMillis.intValue());
                }
            }
        }
    }

    Integer parseBlockingCacheTimeoutMillis(FilterConfig filterConfig) {
        String timeout = filterConfig.getInitParameter(BLOCKING_TIMEOUT_MILLIS);
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void setCacheNameIfAnyConfigured(FilterConfig filterConfig) {
        this.cacheName = filterConfig.getInitParameter(CACHE_NAME);
    }

    protected void doDestroy() {
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, AlreadyCommittedException, FilterNonReentrantException, LockTimeoutException, Exception {
        if (response.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed before doing buildPage.");
        }
        this.logRequestHeaders(request);
        PageInfo pageInfo = this.buildPageInfo(request, response, chain);
        int statusCode = pageInfo.getStatusCode();
        if (statusCode != 200) {
            return;
        }
        if (response.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed after doing buildPagebut before writing response from PageInfo.");
        }
        this.writeResponse(request, response, pageInfo);
    }

    protected PageInfo buildPageInfo(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        PageInfo pageInfo;
        block12: {
            String key = this.calculateKey(request);
            pageInfo = null;
            String originalThreadName = Thread.currentThread().getName();
            try {
                this.checkNoReentry(request);
                Element element = this.blockingCache.get((Serializable)((Object)key));
                if (element == null || element.getObjectValue() == null) {
                    try {
                        pageInfo = this.buildPage(request, response, chain);
                        if (pageInfo.isOk()) {
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.finest("PageInfo ok. Adding to cache " + this.blockingCache.getName() + " with key " + key);
                            }
                            this.blockingCache.put(new Element((Serializable)((Object)key), (Serializable)pageInfo));
                        } else {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("PageInfo was not ok(200). Putting null into cache " + this.blockingCache.getName() + " with key " + key);
                            }
                            this.blockingCache.put(new Element((Serializable)((Object)key), null));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        this.blockingCache.put(new Element((Serializable)((Object)key), null));
                        throw new Exception(throwable);
                    }
                }
                pageInfo = (PageInfo)element.getObjectValue();
            }
            catch (LockTimeoutException e) {
                throw e;
            }
            finally {
                Thread.currentThread().setName(originalThreadName);
            }
        }
        return pageInfo;
    }

    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, Exception {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        GenericResponseWrapper wrapper = new GenericResponseWrapper(response, outstr);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        wrapper.flush();
        long timeToLiveSeconds = this.blockingCache.getCacheConfiguration().getTimeToLiveSeconds();
        return new PageInfo(wrapper.getStatus(), wrapper.getContentType(), wrapper.getHeaders(), wrapper.getCookies(), outstr.toByteArray(), true, timeToLiveSeconds);
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, DataFormatException, ResponseHeadersNotModifiableException {
        boolean requestAcceptsGzipEncoding = this.acceptsGzipEncoding(request);
        this.setStatus(response, pageInfo);
        this.setContentType(response, pageInfo);
        this.setCookies(pageInfo, response);
        this.setHeaders(pageInfo, requestAcceptsGzipEncoding, response);
        this.writeContent(request, response, pageInfo);
    }

    protected void setContentType(HttpServletResponse response, PageInfo pageInfo) {
        String contentType = pageInfo.getContentType();
        if (contentType != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
    }

    protected void setCookies(PageInfo pageInfo, HttpServletResponse response) {
        List cookies = pageInfo.getSerializableCookies();
        Iterator iterator = cookies.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = ((SerializableCookie)iterator.next()).toCookie();
            response.addCookie(cookie);
        }
    }

    protected void setStatus(HttpServletResponse response, PageInfo pageInfo) {
        response.setStatus(pageInfo.getStatusCode());
    }

    protected void setHeaders(PageInfo pageInfo, boolean requestAcceptsGzipEncoding, HttpServletResponse response) {
        List headers = pageInfo.getResponseHeaders();
        boolean header = false;
        boolean value = true;
        for (String[] headerPair : headers) {
            response.setHeader(headerPair[0], headerPair[1]);
        }
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    protected abstract CacheManager getCacheManager();

    protected abstract String calculateKey(HttpServletRequest var1);

    protected void writeContent(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, ResponseHeadersNotModifiableException {
        boolean shouldBodyBeZero;
        byte[] body;
        if (this.acceptsGzipEncoding(request)) {
            ResponseUtil.addGzipHeader(response);
            body = pageInfo.getGzippedBody();
            if (ResponseUtil.shouldGzippedBodyBeZero(body, request)) {
                body = new byte[]{};
            }
        } else {
            body = pageInfo.getUngzippedBody();
        }
        if (shouldBodyBeZero = ResponseUtil.shouldBodyBeZero(request, pageInfo.getStatusCode())) {
            body = new byte[]{};
        }
        response.setContentLength(body.length);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)out).write(body);
        ((OutputStream)out).flush();
    }

    protected void checkNoReentry(HttpServletRequest httpRequest) throws FilterNonReentrantException {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        String filterName = this.getClass().getName();
        if (thread.getName().indexOf(" been through " + filterName) != -1) {
            throw new FilterNonReentrantException("The request thread is attempting to reenter filter " + filterName + ". URL: " + httpRequest.getRequestURL());
        }
        thread.setName(thread.getName() + " been through " + filterName);
        String newThreadName = thread.getName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Thread name changed from " + threadName + " to " + newThreadName);
        }
    }
}

