/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.ConsolePrintingCacheEventListener;
import net.sf.ehcache.event.CacheEventListener;

public final class RemoteDebugger {
    private static final int TWO_SECONDS = 2000;
    private static CacheManager manager;
    private boolean keepMonitoring;
    private ConsolePrintingCacheEventListener consolePrintingCacheEventListener;
    private String configurationFileName;
    private String cacheNameToMonitor;

    public RemoteDebugger(String configurationFileName, String cacheNameToMonitor) throws InterruptedException {
        this.configurationFileName = configurationFileName;
        this.cacheNameToMonitor = cacheNameToMonitor;
        try {
            manager = new CacheManager(configurationFileName);
        }
        catch (CacheException e) {
            System.err.println("Exception starting CacheManager from configuration " + configurationFileName + ". " + "Stack trace follows:");
            e.printStackTrace();
        }
        if (manager == null) {
            return;
        }
    }

    public void init() throws InterruptedException {
        this.keepMonitoring = true;
        if (manager == null) {
            return;
        }
        String availableCaches = this.getDistributedCacheNamesAsString();
        System.out.println("Caches with replication configured which are available for monitoring are: " + availableCaches);
        if (this.cacheNameToMonitor == null) {
            System.out.println("No cache name specified for monitoring. Choose one and add it to the command line as the second argument.");
        } else {
            this.monitorCacheMessages(this.cacheNameToMonitor);
        }
    }

    private void monitorCacheMessages(String cacheNameToMonitor) throws InterruptedException {
        String cacheName = cacheNameToMonitor;
        Cache cache = manager.getCache(cacheName);
        if (cache == null) {
            System.out.println("No cache named " + cacheName + " exists in the CacheManager configuration.");
        } else {
            System.out.println("Monitoring cache: " + cacheName);
            System.out.println("Cache configuration is: " + cache);
            boolean configuredToReplicate = this.isConfiguredToReplicate((Ehcache)cache);
            if (!configuredToReplicate) {
                System.out.println("The cache " + cacheName + " is not configured to replicate therefore no messages" + " will be received by it.");
            } else {
                this.consolePrintingCacheEventListener = new ConsolePrintingCacheEventListener();
                cache.getCacheEventNotificationService().registerListener((CacheEventListener)this.consolePrintingCacheEventListener);
                this.keepMonitoring = true;
            }
            while (this.keepMonitoring) {
                Thread.sleep(2000L);
                System.out.println("Cache: " + cacheName + " Notifications received: " + this.consolePrintingCacheEventListener.getEventsReceivedCount() + " Elements in cache: " + cache.getSize());
            }
        }
    }

    boolean isConfiguredToReplicate(Ehcache cache) {
        Iterator listenersIterator = cache.getCacheEventNotificationService().getCacheEventListeners().iterator();
        boolean configuredToReplicate = false;
        while (listenersIterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)listenersIterator.next();
            if (!(cacheEventListener instanceof CacheReplicator)) continue;
            configuredToReplicate = true;
        }
        return configuredToReplicate;
    }

    String getDistributedCacheNamesAsString() {
        StringBuffer availableCaches = new StringBuffer();
        String[] cacheNames = this.getDistributedCacheNames();
        for (int i = 0; i < cacheNames.length; ++i) {
            String name = cacheNames[i];
            if (!this.isConfiguredToReplicate((Ehcache)manager.getCache(name))) continue;
            availableCaches.append(name).append(' ');
        }
        return availableCaches.toString();
    }

    String[] getDistributedCacheNames() {
        String[] cacheNames = manager.getCacheNames();
        return cacheNames;
    }

    public static void main(String[] args) throws InterruptedException {
        RemoteDebugger remoteDebugger = null;
        if (args.length < 1 || args.length > 2) {
            System.out.println("Command line to list caches to monitor: java -jar ehcache-remote-debugger.jar path_to_ehcache.xml\nCommand line to monitor a specific cache: java -jar ehcache-remote-debugger.jar path_to_ehcache.xml cacheName");
            return;
        }
        if (args.length == 1) {
            System.out.println("Attempting to list caches from the specified configuration");
            remoteDebugger = new RemoteDebugger(args[0], null);
        } else {
            System.out.println("This debugger prints all ehcache debugging messages. Set your log handler to the most detailed level to see the messages.");
            remoteDebugger = new RemoteDebugger(args[0], args[1]);
        }
        remoteDebugger.init();
    }

    public void dispose() {
        this.keepMonitoring = false;
        manager.shutdown();
    }

    static CacheManager getMonitoringCacheManager() {
        return manager;
    }

    public void stopMonitoring(boolean keepMonitoring) {
        this.keepMonitoring = keepMonitoring;
    }

    public ConsolePrintingCacheEventListener getConsolePrintingCacheEventListener() {
        return this.consolePrintingCacheEventListener;
    }
}

