/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.util.ERuntime;
import net.sf.eBus.util.TimerEvent;
import net.sf.eBus.util.TimerTask;
import net.sf.eBus.util.TimerTaskListener;
import net.sf.eBus.util.logging.StatusReporter;

public final class StatusReport
implements TimerTaskListener {
    private static final String THREAD_HEADER = "| Thread Name          | ID         | State           |";
    private static final String THREAD_HEADER_2 = "+----------------------+------------+-----------------+";
    private static StatusReport sInstance;
    private static final Lock sCtorMutex;
    private static final Date sStartTime;
    private static final Timer sTimer;
    private boolean mInitFlag = false;
    private String mAppName = "<app name not set>";
    private String mVersion = "<version not set>";
    private Date mBuildDate = null;
    private String mBoilerPlate = null;
    private Logger mLogger;
    private Level mLevel = Level.INFO;
    private ReportFrequency mFrequency = ReportFrequency.FIFTEEN_MINUTE;
    private final List<StatusReporter> mReporters;
    private TimerTask mReportTimer;
    private boolean mDumpThreadsFlag = false;

    private StatusReport() {
        this.mLogger = Logger.getLogger("");
        this.mReporters = new LinkedList<StatusReporter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(TimerEvent event) {
        LinkedList<StatusReporter> reporters;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Runtime sys = Runtime.getRuntime();
        boolean onAndroid = ERuntime.isAndroid();
        long now = System.currentTimeMillis();
        long upTime = now - sStartTime.getTime();
        long totalMem = sys.totalMemory();
        long freeMem = sys.freeMemory();
        long usedMem = totalMem - freeMem;
        pw.println("STATUS REPORT");
        pw.println();
        this.logHeader(pw);
        pw.println();
        pw.print("          JRE: ");
        pw.print(System.getProperty("java.version"));
        pw.print(" (");
        pw.print(System.getProperty("java.vendor"));
        pw.println(")");
        pw.print("          JVM: ");
        pw.print(System.getProperty("java.vm.name"));
        pw.print(", ");
        pw.print(System.getProperty("java.vm.version"));
        pw.print(" (");
        pw.print(System.getProperty("java.vm.vendor"));
        pw.println(")");
        pw.println();
        pw.print("   Start date: ");
        pw.format("%1$tm/%1$td/%1$tY at %1$tH:%1$tM:S%n", sStartTime);
        pw.print("      Up time: ");
        pw.println(StatusReport.formatTime(upTime));
        pw.format("  Used memory: %,d bytes%n", usedMem);
        pw.format("  Free memory: %,d bytes%n", freeMem);
        pw.format(" Total memory: %,d bytes%n", totalMem);
        if (!onAndroid) {
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            pw.format(" Thread count: %,d (peak %,d)%n%n", threadBean.getThreadCount(), threadBean.getPeakThreadCount());
            if (this.mDumpThreadsFlag) {
                this.outputThreads(pw, threadBean);
                pw.println();
            }
        }
        List<StatusReporter> list = this.mReporters;
        synchronized (list) {
            reporters = new LinkedList<StatusReporter>(this.mReporters);
        }
        reporters.stream().forEach(reporter -> {
            reporter.reportStatus(pw);
            pw.println();
        });
        String report = sw.toString();
        this.mLogger.log(this.mLevel, report);
    }

    public synchronized Logger getLogger() {
        return this.mLogger;
    }

    public synchronized Level getLevel() {
        return this.mLevel;
    }

    public synchronized ReportFrequency getReportFrequency() {
        return this.mFrequency;
    }

    public synchronized boolean getDumpThreads() {
        return this.mDumpThreadsFlag;
    }

    public synchronized void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    public synchronized void setLevel(Level level) {
        this.mLevel = Objects.requireNonNull(level, "null level");
    }

    public synchronized void setReportFrequency(ReportFrequency frequency) {
        if (this.mFrequency != frequency) {
            this.mFrequency = frequency;
            if (this.mReportTimer != null) {
                this.mReportTimer.cancel();
                this.mReportTimer = null;
            }
            this.startReportTimer();
        }
    }

    public synchronized void setDumpThreads(boolean flag) {
        this.mDumpThreadsFlag = flag;
    }

    public synchronized void setApplicationInfo(String name, String version, Date buildDate, String boilerPlate) {
        if (this.mInitFlag) {
            throw new IllegalStateException("app info already set");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.mInitFlag = true;
        this.mAppName = name;
        this.mVersion = version;
        this.mBuildDate = new Date(buildDate.getTime());
        this.mBoilerPlate = boilerPlate;
        pw.println("=================================================================");
        this.logHeader(pw);
        String report = sw.toString();
        this.mLogger.info(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(StatusReporter reporter) {
        List<StatusReporter> list = this.mReporters;
        synchronized (list) {
            if (!this.mReporters.contains(reporter)) {
                this.mReporters.add(reporter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(StatusReporter reporter) {
        List<StatusReporter> list = this.mReporters;
        synchronized (list) {
            this.mReporters.remove(reporter);
        }
    }

    public static StatusReport getsInstance() {
        sCtorMutex.lock();
        try {
            if (sInstance == null) {
                sInstance = new StatusReport();
                sInstance.startReportTimer();
            }
        }
        finally {
            sCtorMutex.unlock();
        }
        return sInstance;
    }

    public static String formatTime(long delta) {
        TimeUnit[] timeUnits = TimeUnit.values();
        int numUnits = timeUnits.length;
        long delta2 = delta;
        StringBuilder retval = new StringBuilder();
        boolean startFlag = false;
        for (int i = numUnits - 1; i >= 2; --i) {
            long scalar = timeUnits[i].convert(delta2, TimeUnit.MILLISECONDS);
            delta2 -= TimeUnit.MILLISECONDS.convert(scalar, timeUnits[i]);
            if (scalar <= 0L && !startFlag) continue;
            if (!startFlag) {
                startFlag = true;
            } else {
                retval.append(", ");
            }
            retval.append(scalar).append(' ').append(timeUnits[i].name().toLowerCase());
        }
        if (!startFlag) {
            retval.append("0 millisecs");
        }
        return retval.toString();
    }

    private void logHeader(PrintWriter pw) {
        pw.print(this.mAppName);
        pw.print(" v. ");
        pw.print(this.mVersion);
        if (this.mBuildDate != null) {
            pw.format(" (build %1$tm/%1$td/%1$tY at %1$tH:%1$tM:%1$tS)%n", this.mBuildDate);
        }
        if (this.mBoilerPlate != null) {
            pw.println();
            pw.println(this.mBoilerPlate);
        }
        pw.println();
        pw.print("Current working directory is ");
        pw.print(System.getProperty("user.dir"));
        pw.println(".");
        pw.print("Class path is ");
        pw.print(System.getProperty("java.class.path"));
        pw.println(".");
    }

    private void startReportTimer() {
        long frequency = this.mFrequency.getFrequency();
        long reportDelay = frequency - System.currentTimeMillis() % frequency;
        this.mReportTimer = new TimerTask(this);
        sTimer.scheduleAtFixedRate((java.util.TimerTask)this.mReportTimer, reportDelay, frequency);
    }

    private void outputThreads(PrintWriter pw, ThreadMXBean threadBean) {
        long[] threadIds = threadBean.getAllThreadIds();
        int numThreads = threadIds.length;
        pw.println("Active threads:");
        pw.println(THREAD_HEADER_2);
        pw.println(THREAD_HEADER);
        pw.println(THREAD_HEADER_2);
        for (int index = 0; index < numThreads; ++index) {
            ThreadInfo threadInfo = threadBean.getThreadInfo(threadIds[index]);
            if (threadInfo == null) continue;
            pw.format("| %20s | %10d | %15s |%n", new Object[]{threadInfo.getThreadName(), threadIds[index], threadInfo.getThreadState()}).println(THREAD_HEADER_2);
        }
    }

    static {
        sCtorMutex = new ReentrantLock();
        sStartTime = new Date();
        sTimer = new Timer("ReportTimer", true);
    }

    public static enum ReportFrequency {
        THIRTY_SECONDS(30000L),
        FIVE_MINUTE(300000L),
        TEN_MINUTE(600000L),
        FIFTEEN_MINUTE(900000L),
        TWENTY_MINUTE(1200000L),
        THIRTY_MINUTE(1800000L),
        HOURLY(3600000L);

        private final long mFrequency;

        private ReportFrequency(long frequency) {
            this.mFrequency = frequency;
        }

        public long getFrequency() {
            return this.mFrequency;
        }
    }
}

