/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import com.google.common.base.Strings;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.sf.eBus.util.MultiKey2;
import net.sf.eBus.util.ValidationException;

public class Validator {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String NOT_SET = "not set";
    public static final int NAME_INDEX = 0;
    public static final int MESSAGE_INDEX = 1;
    private final List<MultiKey2<String, String>> mErrors = new ArrayList<MultiKey2<String, String>>();

    public String toString() {
        String sep = "";
        StringBuilder retval = new StringBuilder();
        for (MultiKey2<String, String> error : this.mErrors) {
            retval.append(sep).append(error.key(0)).append(": ").append(error.key(1));
            sep = NEWLINE;
        }
        return retval.toString();
    }

    public boolean isEmpty() {
        return this.mErrors.isEmpty();
    }

    public int size() {
        return this.mErrors.size();
    }

    public List<MultiKey2<String, String>> errors() {
        return this.mErrors.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.mErrors);
    }

    public Validator addError(MultiKey2<String, String> error) {
        if (error != null) {
            this.mErrors.add(error);
        }
        return this;
    }

    public Validator requireNotNull(Object value, String fieldName) {
        if (value == null) {
            this.mErrors.add(new MultiKey2<String, String>(fieldName, NOT_SET));
        }
        return this;
    }

    public Validator requireNotNullOrEmpty(String value, String fieldName) {
        if (Strings.isNullOrEmpty((String)value)) {
            this.mErrors.add(new MultiKey2<String, String>(fieldName, "null or empty"));
        }
        return this;
    }

    public Validator requireEquals(Object value, Object expected, String fieldName) {
        if (!Objects.equals(value, expected)) {
            this.mErrors.add(new MultiKey2<String, CallSite>(fieldName, (CallSite)((Object)("does not equal \"" + expected + "\""))));
        }
        return this;
    }

    public <V> Validator requireTrue(Predicate<V> predicate, V value, String fieldName, String message) {
        if (!predicate.test(value)) {
            this.mErrors.add(new MultiKey2<String, String>(fieldName, message));
        }
        return this;
    }

    public <V1, V2> Validator requireTrue(BiPredicate<V1, V2> predicate, V1 value1, V2 value2, String fieldName1, String fieldName2, String message) {
        if (!predicate.test(value1, value2)) {
            this.mErrors.add(new MultiKey2<String, String>(fieldName1, message));
            this.mErrors.add(new MultiKey2<String, String>(fieldName2, message));
        }
        return this;
    }

    public Validator requireTrue(boolean flag, String fieldName, String message) {
        if (!flag) {
            this.mErrors.add(new MultiKey2<String, String>(fieldName, message));
        }
        return this;
    }

    public void throwException(Class<?> tc) {
        if (!this.mErrors.isEmpty()) {
            throw new ValidationException(tc, this.mErrors);
        }
    }

    public void throwException(Class<?> tc, Throwable cause) {
        if (!this.mErrors.isEmpty()) {
            throw new ValidationException(tc, this.mErrors, cause);
        }
    }
}

