/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LazyString {
    private static final String NOT_SET = new String("(not set)");
    private final AtomicBoolean mIsInitialized = new AtomicBoolean();
    private final AtomicReference<String> mText = new AtomicReference<String>(NOT_SET);
    private final Supplier<String> mInitializer;

    public LazyString(Supplier<String> initializer) {
        this.mInitializer = initializer;
    }

    public String toString() {
        return this.get();
    }

    @Nullable
    public String get() {
        String retval;
        while ((retval = this.mText.get()) == NOT_SET) {
            if (!this.mIsInitialized.compareAndSet(false, true)) continue;
            this.mText.set(this.mInitializer.get());
        }
        return retval;
    }
}

