//
// Copyright 2012 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * This regular expression package is designed to perform
 * efficient pattern matching over a
 * {@link net.sf.eBus.util.TernarySearchTree TernarySearchTree}.
 * A {@link net.sf.eBus.util.regex.Pattern Pattern} may be used
 * with the ternary search tree (TST) methods {@code keySet},
 * {@code values} and {@code entrySet}. Only those entries which
 * match the pattern are returned.
 * <p>
 * <b>Warning:</b> Pattern matching over a TST may result in
 * significant CPU usage. A pattern with wildcards first
 * (example: ".+xyz") will traverse the entire TST. If you must
 * use such patterns but you do not need to find all matching
 * entries, then consider using the {@code maxMatches}
 * parameter. Once the specified number of matches are found,
 * the method stops the search and returns.
 * <p>
 * If you need to perform regular expression pattern matching
 * on text only, then use the {@link java.util.regex.Pattern}
 * package. Do <em>not</em> use this package for text matching
 * only.
 * <p>
 * If you do use pattern matching, then best to use patterns
 * that begin with concrete values and place wildcards at the
 * end.
 */

package net.sf.eBus.util.regex;
