//
// Copyright 2001 - 2005 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

import java.util.EventObject;

/**
 * A {@code TimerEvent} event is sent to those
 * {@link net.sf.eBus.util.TimerTaskListener} objects registered
 * with an expired {@link net.sf.eBus.util.TimerTask}.
 * <p>
 * <i>Note:</i> The event's source is a
 * {@link net.sf.eBus.util.TimerTask}.
 * @see net.sf.eBus.util.TimerTask
 * @see net.sf.eBus.util.TimerTaskListener
 *
 * @deprecated Will remove in future releases. Please see
 * {@code net.sf.eBus.client.EScheduledExecutor}.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

@Deprecated
@SuppressWarnings({"java:S1948"})
public final class TimerEvent
    extends EventObject
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     *  This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x050200L;

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     * The associated value.
     */
    private final Object mValue;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a timer event for the specified timer task.
     * The timer task is the event source.
     * The value is the one passed to
     * {@link net.sf.eBus.util.TimerTask#TimerTask(net.sf.eBus.util.TimerTaskListener, java.lang.Object)}.
     * @param timerTask The event source.
     * @param value The timer's associated value. May be
     * {@code null}.
     * @see net.sf.eBus.util.TimerTask
     */
    public TimerEvent(final TimerTask timerTask,
                      final Object value)
    {
        super (timerTask);

        mValue = value;
    } // end of TimerEvent(TimerTask)

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Get methods.
    //

    /**
     * Returns the timer task associated value. May return
     * {@code null}.
     * @return the timer task associated value.
     */
    public Object value()
    {
        return (mValue);
    } // end of value()

    //
    // end of Get methods.
    //-----------------------------------------------------------

    /**
     * Cancels the underlying {@link TimerTask timer task}.
     * @see TimerTask
     */
    public void cancel()
    {
        ((TimerTask) this.source).cancel();
    } // end of cancel()
} // end of class TimerEvent
