//
// Copyright 2005 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

/**
 * This {@link MultiKey} subclass uses generics to guarantee
 * key type and order. {@link MultiKey} is unable to provide
 * this type safety.
 * @param <K1> The first key type.
 * @param <K2> The second key type.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public class MultiKey2<K1, K2>
    extends MultiKey
{
//---------------------------------------------------------------
// Member data.
//

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a two value {@link MultiKey}.
     * @param key1 the first key.
     * @param key2 the second key.
     */
    public MultiKey2(final K1 key1, final K2 key2)
    {
        super (key1, key2);
    } // end of MultiKey2(K1, K2)

    //
    // end of Constructors.
    //-----------------------------------------------------------
} // end of class MultiKey2
