//
// Copyright 2023 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

/**
 * Provides a method to determine if running on Android virtual
 * machine.
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

public final class ERuntime
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     * Virtual machine name is stored in property {@value}.
     */
    private static final String VM_NAME_PROPERTY =
        "java.vm.name";

    /**
     * The Android virtual machine name is {@value}.
     */
    private static final String ANDROID_VM_NAME = "Dalvik";

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    // Private constructor to prevent instantiation.
    private ERuntime()
    {}

    //
    // end of Constructors.
    //-----------------------------------------------------------

    /**
     * Returns {@code true} if property {@link #VM_NAME_PROPERTY}
     * equals {@link #ANDROID_VM_NAME}.
     * @return {@code true} if running on an Android virtual
     * machine.
     */
    public static boolean isAndroid()
    {
        final String vmName =
            System.getProperty(VM_NAME_PROPERTY);

        return (ANDROID_VM_NAME.equals(vmName));
    } // end of isAndroid()
} // end of class ERuntime
