/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.regex;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.eBus.util.regex.AnyChar;
import net.sf.eBus.util.regex.CharacterSet;
import net.sf.eBus.util.regex.Component;
import net.sf.eBus.util.regex.Literal;
import net.sf.eBus.util.regex.RegexLexerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegexLexer {
    static final int TOKEN_NOT_SET = 0;
    static final int DONE_FAILED = 1;
    static final int DONE_SUCCESS = 2;
    static final int REGEX_COMPONENT = 3;
    static final int TOKEN_COUNT = 4;
    static final int SIZE_NOT_SET = -2;
    private static final int MIN_ASCII_CHAR = 0;
    private static final int MAX_ASCII_CHAR = 128;
    private static final int MAX_OCTAL_CHAR = 255;
    static final int DIGIT_FIRST = 48;
    static final int DIGIT_LAST = 57;
    static final int LC_ALPHA_FIRST = 97;
    static final int LC_ALPHA_LAST = 122;
    static final int UC_ALPHA_FIRST = 65;
    static final int UC_ALPHA_LAST = 90;
    static final int[] WHITESPACE = new int[]{32, 9, 10, 11, 12, 13};
    private static final Logger sLogger = LoggerFactory.getLogger(RegexLexer.class);
    private static String[] sTokenTypeNames;
    private static Method[] sTransMethod;
    private final RegexLexerContext mFsm = new RegexLexerContext(this);
    private final StringReader mInput;
    private int mIndex;
    private final Token mToken;
    private int mTokenCount;
    private final StringBuilder mTokenBuffer;
    private boolean mStopFlag;
    private int mcComponentType;
    private int mcLiteral;
    private final SortedSet<Character> mcCharacterSet;
    private boolean mcNegatedFlag;
    private int mcFirstCharacter;
    private final StringBuilder mcNumber;
    private int mcMinimumSize;
    private int mcMaximumSize;

    RegexLexer(String s) {
        this.mInput = new StringReader(s);
        this.mIndex = -1;
        this.mToken = new Token();
        this.mTokenCount = 0;
        this.mTokenBuffer = new StringBuilder();
        this.mStopFlag = false;
        this.mcComponentType = 0;
        this.mcLiteral = -1;
        this.mcCharacterSet = new TreeSet<Character>();
        this.mcNegatedFlag = false;
        this.mcFirstCharacter = -1;
        this.mcNumber = new StringBuilder();
        this.mcMinimumSize = -2;
        this.mcMaximumSize = -2;
    }

    Token nextToken() {
        try {
            this.mStopFlag = false;
            while (!this.mStopFlag) {
                int c = this.readChar();
                if (c < 0) {
                    this.mFsm.EOS();
                    continue;
                }
                if (c >= 128) {
                    this.mTokenBuffer.append((char)c);
                    this.mFsm.alpha(c);
                    continue;
                }
                this.mTokenBuffer.append((char)c);
                sTransMethod[c].invoke((Object)this.mFsm, c);
            }
        }
        catch (IOException | IllegalAccessException jex) {
            this.badToken(jex);
        }
        catch (InvocationTargetException inex) {
            this.badToken(inex.getCause());
        }
        return this.mToken;
    }

    int readChar() throws IOException {
        this.mInput.mark(1);
        ++this.mIndex;
        return this.mInput.read();
    }

    void unreadChar() {
        try {
            int bufferSize = this.mTokenBuffer.length();
            this.mInput.reset();
            --this.mIndex;
            if (bufferSize > 0) {
                this.mTokenBuffer.deleteCharAt(bufferSize - 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void closeInput() {
        this.mInput.close();
    }

    int tokenCount() {
        return this.mTokenCount;
    }

    void startToken(int componentType) {
        this.mToken.clear();
        this.mToken.type(3);
        this.mcComponentType = componentType;
        this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
        this.mcLiteral = -1;
        this.mcCharacterSet.clear();
        this.mcNegatedFlag = false;
        this.mcFirstCharacter = -1;
        this.mcNumber.delete(0, this.mcNumber.length());
        this.mcMinimumSize = -2;
        this.mcMaximumSize = -2;
    }

    void endToken(int minSize, int maxSize) {
        this.mToken.value(this.mTokenBuffer.toString());
        switch (this.mcComponentType) {
            case 1: {
                this.mToken.regexComponent(new Literal((char)this.mcLiteral, minSize, maxSize, this.mTokenCount));
                break;
            }
            case 2: {
                TreeSet<Character> setCopy = new TreeSet<Character>(this.mcCharacterSet);
                this.mToken.regexComponent(new CharacterSet(setCopy, this.mcNegatedFlag, minSize, maxSize, this.mTokenCount));
                break;
            }
            default: {
                this.mToken.regexComponent(new AnyChar(minSize, maxSize, this.mTokenCount));
            }
        }
        ++this.mTokenCount;
        this.mStopFlag = true;
    }

    void badToken(String message) {
        this.mToken.type(1);
        this.mToken.value(this.mTokenBuffer.toString());
        this.mToken.errorMessage(message);
        this.mToken.index(this.mIndex);
        this.mStopFlag = true;
    }

    void badToken(Throwable cause) {
        this.mToken.type(1);
        this.mToken.value(this.mTokenBuffer.toString());
        this.mToken.errorMessage(cause.getMessage());
        this.mToken.cause(cause);
        this.mToken.index(this.mIndex);
        this.mStopFlag = true;
    }

    void done() {
        this.mToken.type(2);
        this.mToken.regexComponent(null);
        this.mToken.value(null);
        this.mToken.errorMessage(null);
        this.mToken.cause(null);
        this.mStopFlag = true;
    }

    void literal(int c) {
        this.mcLiteral = c;
    }

    void negatedFlag(boolean flag) {
        this.mcNegatedFlag = flag;
    }

    int characterSetSize() {
        return this.mcCharacterSet.size();
    }

    void addToSet(int c) {
        this.mcCharacterSet.add(Character.valueOf((char)c));
    }

    void addToSet(int first, int last) {
        for (int index = first; index <= last; ++index) {
            this.mcCharacterSet.add(Character.valueOf((char)index));
        }
    }

    void addToSet(int[] cs) {
        for (int c : cs) {
            this.mcCharacterSet.add(Character.valueOf((char)c));
        }
    }

    int firstCharacter() {
        return this.mcFirstCharacter;
    }

    void firstCharacter(int c) {
        this.mcFirstCharacter = c;
    }

    int numberLength() {
        return this.mcNumber.length();
    }

    String number() {
        return this.mcNumber.toString();
    }

    void appendNumber(int c) {
        this.mcNumber.append((char)c);
    }

    void clearNumber() {
        this.mcNumber.delete(0, this.mcNumber.length());
    }

    int minimumSize() {
        return this.mcMinimumSize;
    }

    void minimumSize(int size) {
        this.mcMinimumSize = size;
    }

    boolean minimumSize(String s) {
        boolean retcode = true;
        try {
            this.mcMinimumSize = Integer.parseInt(s);
        }
        catch (NumberFormatException formex) {
            retcode = false;
            this.mcMinimumSize = -2;
        }
        return retcode;
    }

    int maximumSize() {
        return this.mcMaximumSize;
    }

    boolean maximumSize(String s) {
        boolean retcode = true;
        try {
            this.mcMaximumSize = Integer.parseInt(s);
        }
        catch (NumberFormatException formex) {
            retcode = false;
            this.mcMaximumSize = -2;
        }
        return retcode;
    }

    void maximumSize(int size) {
        this.mcMaximumSize = size;
    }

    boolean isOctal() {
        int i = Integer.parseInt(this.mTokenBuffer.substring(2), 8);
        return i <= 255;
    }

    char octalChar() {
        char retval;
        try {
            retval = (char)Integer.parseInt(this.mTokenBuffer.substring(2), 8);
        }
        catch (NumberFormatException jex) {
            retval = '\u0000';
        }
        return retval;
    }

    char hexChar() {
        char retval;
        try {
            retval = (char)Integer.parseInt(this.mTokenBuffer.substring(2), 16);
        }
        catch (NumberFormatException jex) {
            retval = '\u0000';
        }
        return retval;
    }

    static {
        String transName = "<not set>";
        sTokenTypeNames = new String[4];
        RegexLexer.sTokenTypeNames[0] = "TOKEN_NOT_SET";
        RegexLexer.sTokenTypeNames[1] = "DONE_FAILED";
        RegexLexer.sTokenTypeNames[2] = "DONE_SUCCESS";
        RegexLexer.sTokenTypeNames[3] = "REGEX_COMPONENT";
        sTransMethod = new Method[129];
        try {
            int i;
            Class<RegexLexerContext> fsmClass = RegexLexerContext.class;
            Class[] paramTypes = new Class[]{Integer.TYPE};
            transName = "alpha";
            Method alpha = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "digit";
            Method digit = fsmClass.getDeclaredMethod(transName, paramTypes);
            for (i = 0; i < 128; ++i) {
                RegexLexer.sTransMethod[i] = alpha;
            }
            for (i = 48; i <= 57; ++i) {
                RegexLexer.sTransMethod[i] = digit;
            }
            transName = "asterisk";
            RegexLexer.sTransMethod[42] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "plus";
            RegexLexer.sTransMethod[43] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "question_mark";
            RegexLexer.sTransMethod[63] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "period";
            RegexLexer.sTransMethod[46] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_bracket";
            RegexLexer.sTransMethod[91] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "right_bracket";
            RegexLexer.sTransMethod[93] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "up_arrow";
            RegexLexer.sTransMethod[94] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "dash";
            RegexLexer.sTransMethod[45] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_brace";
            RegexLexer.sTransMethod[123] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "right_brace";
            RegexLexer.sTransMethod[125] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "comma";
            RegexLexer.sTransMethod[44] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "backslash";
            RegexLexer.sTransMethod[92] = fsmClass.getDeclaredMethod(transName, paramTypes);
        }
        catch (NoSuchMethodException | SecurityException jex) {
            sLogger.error("INITIALIZATION ERROR! No such method as net.sf.eBus.util.regex.LexerContext.{}(int).", (Object)transName);
        }
    }

    public static final class Token {
        private int mType = 0;
        private Component mRegexComponent = null;
        private String mValue = null;
        private String mErrorMessage = null;
        private Throwable mCause = null;
        private int mIndex = -1;

        public int type() {
            return this.mType;
        }

        public Component regexComponent() {
            return this.mRegexComponent;
        }

        public String value() {
            return this.mValue;
        }

        public String errorMessage() {
            return this.mErrorMessage;
        }

        public Throwable cause() {
            return this.mCause;
        }

        public int index() {
            return this.mIndex;
        }

        public void type(int type) {
            this.mType = type;
        }

        public void regexComponent(Component component) {
            this.mRegexComponent = component;
        }

        public void value(String value) {
            this.mValue = value;
        }

        public void errorMessage(String message) {
            this.mErrorMessage = message;
        }

        public void cause(Throwable cause) {
            this.mCause = cause;
        }

        public void index(int index) {
            this.mIndex = index;
        }

        public void clear() {
            this.mType = 0;
            this.mRegexComponent = null;
            this.mValue = null;
            this.mErrorMessage = null;
            this.mCause = null;
            this.mIndex = -1;
        }
    }
}

