/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.logging;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public final class PatternFormatter
extends Formatter {
    public static final String DEFAULT_PATTERN = "%d{MM/dd/yyyy HH:mm:ss} %m%E";
    private static final int NO_JUSTIFY = 0;
    private static final int LEFT_JUSTIFY = 1;
    private static final int RIGHT_JUSTIFY = 2;
    private static final String SPECIFIER_LETTERS = "CeElmMNst";
    private static final int TEXT = 0;
    private static final int PERCENT = 1;
    private static final int MIN_WIDTH = 3;
    private static final int MAX_WIDTH = 4;
    private static final int DATE_FORMAT = 5;
    private static final int DATE_FORMAT_2 = 6;
    private static final String PATTERN_KEY = "net.sf.eBus.util.logging.PatternFormatter.pattern";
    private List<SubFormat> mSubformats;

    public PatternFormatter() {
        String pattern = LogManager.getLogManager().getProperty(PATTERN_KEY);
        if (pattern == null || pattern.length() == 0) {
            pattern = DEFAULT_PATTERN;
        }
        this.parsePattern(pattern);
    }

    public PatternFormatter(String pattern) {
        if (Strings.isNullOrEmpty((String)pattern)) {
            throw new IllegalArgumentException("null or empty pattern");
        }
        this.parsePattern(pattern);
    }

    @Override
    public String format(LogRecord logRecord) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.mSubformats.forEach(f -> f.format(logRecord, pw));
        pw.println();
        return sw.toString();
    }

    private void parsePattern(String pattern) {
        byte[] buffer = pattern.getBytes(StandardCharsets.US_ASCII);
        StringBuilder text = new StringBuilder();
        int justification = 0;
        int minWidth = 0;
        int maxWidth = 0;
        this.mSubformats = new ArrayList<SubFormat>(20);
        int state = 0;
        block13: for (int i = 0; i < buffer.length; ++i) {
            switch (state) {
                case 0: {
                    if (buffer[i] == 37) {
                        state = 1;
                        continue block13;
                    }
                    text.append((char)buffer[i]);
                    continue block13;
                }
                case 1: {
                    switch (buffer[i]) {
                        case 37: {
                            text.append('%');
                            state = 0;
                            continue block13;
                        }
                        case 110: {
                            if (text.length() > 0) {
                                this.mSubformats.add(new ConstantFormat(text.toString()));
                                text.delete(0, text.length());
                            }
                            this.mSubformats.add(new NewLineFormat());
                            state = 0;
                            continue block13;
                        }
                    }
                    if (text.length() > 0) {
                        this.mSubformats.add(new ConstantFormat(text.toString()));
                        text.delete(0, text.length());
                    }
                    if (buffer[i] == 45) {
                        justification = 2;
                        state = 2;
                        continue block13;
                    }
                    if (buffer[i] == 46) {
                        justification = 1;
                        state = 4;
                        continue block13;
                    }
                    if (Character.isDigit((char)buffer[i])) {
                        text.append((char)buffer[i]);
                        justification = 1;
                        state = 3;
                        continue block13;
                    }
                    if (buffer[i] == 100) {
                        state = 5;
                        continue block13;
                    }
                    if (this.isValidLetter(buffer[i])) {
                        this.mSubformats.add(this.createSubFormat(buffer[i], justification, minWidth, maxWidth));
                        state = 0;
                        continue block13;
                    }
                    text.delete(0, text.length());
                    text.append('\'');
                    text.append((char)buffer[i]);
                    text.append("' is not a valid specifier");
                    throw new IllegalArgumentException(text.toString());
                }
                case 2: {
                    if (Character.isDigit((char)buffer[i])) {
                        text.append((char)buffer[i]);
                        state = 3;
                        continue block13;
                    }
                    text.delete(0, text.length());
                    text.append("'-' not followed by ");
                    text.append("minimum width");
                    throw new IllegalArgumentException(text.toString());
                }
                case 3: {
                    if (Character.isDigit((char)buffer[i])) {
                        text.append((char)buffer[i]);
                        continue block13;
                    }
                    if (buffer[i] == 46) {
                        minWidth = Integer.parseInt(text.toString());
                        text.delete(0, text.length());
                        state = 4;
                        continue block13;
                    }
                    if (buffer[i] == 100) {
                        minWidth = Integer.parseInt(text.toString());
                        text.delete(0, text.length());
                        state = 5;
                        continue block13;
                    }
                    if (buffer[i] == 69) {
                        throw new IllegalArgumentException("%E does not take modifiers");
                    }
                    if (this.isValidLetter(buffer[i])) {
                        minWidth = Integer.parseInt(text.toString());
                        this.mSubformats.add(this.createSubFormat(buffer[i], justification, minWidth, maxWidth));
                        text.delete(0, text.length());
                        justification = 0;
                        minWidth = 0;
                        maxWidth = 0;
                        state = 0;
                        continue block13;
                    }
                    text.append(" minimum width followed ");
                    text.append("by invalid character '");
                    text.append((char)buffer[i]);
                    text.append('\'');
                    throw new IllegalArgumentException(text.toString());
                }
                case 4: {
                    if (Character.isDigit((char)buffer[i])) {
                        text.append((char)buffer[i]);
                        continue block13;
                    }
                    if (buffer[i] == 100) {
                        maxWidth = Integer.parseInt(text.toString());
                        text.delete(0, text.length());
                        state = 5;
                        continue block13;
                    }
                    if (buffer[i] == 69) {
                        throw new IllegalArgumentException("%E does not take modifiers");
                    }
                    if (this.isValidLetter(buffer[i])) {
                        maxWidth = Integer.parseInt(text.toString());
                        this.mSubformats.add(this.createSubFormat(buffer[i], justification, minWidth, maxWidth));
                        text.delete(0, text.length());
                        justification = 0;
                        minWidth = 0;
                        maxWidth = 0;
                        state = 0;
                        continue block13;
                    }
                    text.append(" maximum width followed ");
                    text.append("by invalid character '");
                    text.append((char)buffer[i]);
                    text.append('\'');
                    throw new IllegalArgumentException(text.toString());
                }
                case 5: {
                    if (buffer[i] == 123) {
                        state = 6;
                        continue block13;
                    }
                    this.mSubformats.add(new DateFormat(justification, minWidth, maxWidth));
                    text.append((char)buffer[i]);
                    justification = 0;
                    minWidth = 0;
                    maxWidth = 0;
                    state = 0;
                    continue block13;
                }
                case 6: {
                    if (buffer[i] == 125) {
                        this.mSubformats.add(new DateFormat(text.toString(), justification, minWidth, maxWidth));
                        text.delete(0, text.length());
                        justification = 0;
                        minWidth = 0;
                        maxWidth = 0;
                        state = 0;
                        continue block13;
                    }
                    text.append((char)buffer[i]);
                    continue block13;
                }
            }
        }
        if (state == 5) {
            this.mSubformats.add(new DateFormat(justification, minWidth, maxWidth));
        } else {
            if (state != 0) {
                throw new IllegalArgumentException("pattern ends with incomplete specifier");
            }
            if (text.length() > 0) {
                this.mSubformats.add(new ConstantFormat(text.toString()));
            }
        }
    }

    private boolean isValidLetter(byte c) {
        return SPECIFIER_LETTERS.indexOf(c) >= 0;
    }

    private SubFormat createSubFormat(byte c, int justify, int minWidth, int maxWidth) {
        SubFormat retval = null;
        switch (c) {
            case 67: {
                retval = new SourceClassFormat(justify, minWidth, maxWidth);
                break;
            }
            case 101: {
                retval = new ThrowableMessageFormat(justify, minWidth, maxWidth);
                break;
            }
            case 69: {
                retval = new StackTraceFormat(justify, minWidth, maxWidth);
                break;
            }
            case 108: {
                retval = new LevelFormat(justify, minWidth, maxWidth);
                break;
            }
            case 109: {
                retval = new MessageFormat(justify, minWidth, maxWidth);
                break;
            }
            case 77: {
                retval = new SourceMethodFormat(justify, minWidth, maxWidth);
                break;
            }
            case 78: {
                retval = new LoggerNameFormat(justify, minWidth, maxWidth);
                break;
            }
            case 115: {
                retval = new SequenceFormat(justify, minWidth, maxWidth);
                break;
            }
            case 116: {
                retval = new ThreadIdFormat(justify, minWidth, maxWidth);
                break;
            }
        }
        return retval;
    }

    private final class SourceMethodFormat
    extends SubFormat {
        public SourceMethodFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.justify(logRecord.getSourceMethodName()));
        }
    }

    private final class SourceClassFormat
    extends SubFormat {
        public SourceClassFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.justify(logRecord.getSourceClassName()));
        }
    }

    private final class SequenceFormat
    extends SubFormat {
        public SequenceFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.justify(Long.toString(logRecord.getSequenceNumber())));
        }
    }

    private final class ThreadIdFormat
    extends SubFormat {
        public ThreadIdFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.justify(Integer.toString(logRecord.getThreadID())));
        }
    }

    private final class StackTraceFormat
    extends SubFormat {
        public StackTraceFormat(int justify, int minWidth, int maxWidth) {
            super(0, 0, 0);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            Throwable t = logRecord.getThrown();
            if (t != null) {
                pw.println();
                t.printStackTrace(pw);
            }
        }
    }

    private final class ThrowableMessageFormat
    extends SubFormat {
        public ThrowableMessageFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            Throwable t = logRecord.getThrown();
            String message = "";
            if (t != null) {
                message = t.getMessage();
            }
            pw.print(this.justify(message));
        }
    }

    private final class MessageFormat
    extends SubFormat {
        public MessageFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            String localizedMessage;
            ResourceBundle bundle = logRecord.getResourceBundle();
            String rawMessage = logRecord.getMessage();
            if (rawMessage == null || rawMessage.length() == 0) {
                localizedMessage = "";
            } else if (bundle == null) {
                localizedMessage = rawMessage;
            } else {
                try {
                    localizedMessage = bundle.getString(rawMessage);
                }
                catch (Exception jex) {
                    localizedMessage = rawMessage;
                }
            }
            pw.print(this.justify(localizedMessage));
        }
    }

    private final class LoggerNameFormat
    extends SubFormat {
        public LoggerNameFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(logRecord.getLoggerName());
        }
    }

    private final class LevelFormat
    extends SubFormat {
        public LevelFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.justify(logRecord.getLevel().getLocalizedName()));
        }
    }

    private final class DateFormat
    extends SubFormat {
        private final SimpleDateFormat mDateFormat;

        public DateFormat(int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
            this.mDateFormat = new SimpleDateFormat();
        }

        public DateFormat(String format, int justify, int minWidth, int maxWidth) {
            super(justify, minWidth, maxWidth);
            this.mDateFormat = new SimpleDateFormat(format);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.justify(this.mDateFormat.format(new Date(logRecord.getMillis()))));
        }
    }

    private final class NewLineFormat
    extends SubFormat {
        public NewLineFormat() {
            super(0, 0, 0);
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.println();
        }
    }

    private final class ConstantFormat
    extends SubFormat {
        private final String mString;

        public ConstantFormat(String s) {
            super(0, 0, 0);
            this.mString = s;
        }

        @Override
        public void format(LogRecord logRecord, PrintWriter pw) {
            pw.print(this.mString);
        }
    }

    private abstract class SubFormat {
        private int mJustification;
        private int mMinimumWidth;
        private int mMaximumWidth;

        protected SubFormat(int justification, int minWidth, int maxWidth) {
            this.mJustification = justification;
            this.mMinimumWidth = minWidth;
            this.mMaximumWidth = maxWidth;
        }

        public abstract void format(LogRecord var1, PrintWriter var2);

        protected String justify(String s) {
            String retval;
            String text = s == null ? "" : s;
            int length = text.length();
            if (this.mJustification == 0) {
                retval = text;
            } else if (this.mMinimumWidth > 0 && length < this.mMinimumWidth) {
                StringBuilder buffer = new StringBuilder();
                int paddingLength = this.mMinimumWidth - length;
                char[] padding = new char[paddingLength];
                Arrays.fill(padding, ' ');
                if (this.mJustification == 1) {
                    buffer.append(padding);
                    buffer.append(s);
                } else {
                    buffer.append(s);
                    buffer.append(padding);
                }
                retval = buffer.toString();
            } else {
                retval = this.mMaximumWidth > 0 && length > this.mMaximumWidth ? text.substring(0, this.mMaximumWidth) : s;
            }
            return retval;
        }
    }
}

