/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public final class SequentialTask
implements Runnable {
    private static final Map<Object, TaskIndex> sIndexMap = new WeakHashMap<Object, TaskIndex>();
    private static final Lock sIndexLock = new ReentrantLock(true);
    private final int mIndex;
    private final TaskIndex mTaskIndex;
    private final Runnable mTask;
    private final Logger mLogger;

    private SequentialTask(TaskIndex taskIndex, Runnable task, Logger logger) {
        this.mIndex = taskIndex.assignIndex();
        this.mTaskIndex = taskIndex;
        this.mTask = task;
        this.mLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskIndex taskIndex = this.mTaskIndex;
        synchronized (taskIndex) {
            block8: {
                while (this.mIndex != this.mTaskIndex.currentIndex()) {
                    try {
                        this.mTaskIndex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    this.mTask.run();
                }
                catch (Exception jex) {
                    if (this.mLogger == null) break block8;
                    this.mLogger.warn("task exception", (Throwable)jex);
                }
            }
            this.mTaskIndex.incrementIndex();
            this.mTaskIndex.notifyAll();
        }
    }

    public int index() {
        return this.mIndex;
    }

    public static SequentialTask createTask(Object o, Runnable task) {
        return SequentialTask.createTask(o, task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequentialTask createTask(Object o, Runnable task, Logger logger) {
        SequentialTask retval = null;
        if (o == null) {
            throw new IllegalArgumentException("null o");
        }
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        sIndexLock.lock();
        try {
            TaskIndex taskIndex;
            if (!sIndexMap.containsKey(o)) {
                taskIndex = new TaskIndex();
                sIndexMap.put(o, taskIndex);
            } else {
                taskIndex = sIndexMap.get(o);
            }
            retval = new SequentialTask(taskIndex, task, logger);
        }
        finally {
            sIndexLock.unlock();
        }
        return retval;
    }

    private static final class TaskIndex {
        private int mCurrentIndex = 0;
        private int mAssignIndex = 0;

        private TaskIndex() {
        }

        private int currentIndex() {
            return this.mCurrentIndex;
        }

        private int assignIndex() {
            int retval = this.mAssignIndex++;
            this.mAssignIndex %= Integer.MAX_VALUE;
            return retval;
        }

        private void incrementIndex() {
            ++this.mCurrentIndex;
            this.mCurrentIndex %= Integer.MAX_VALUE;
        }
    }
}

