//
// Copyright 2013 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * This handler quietly does nothing with the given log records.
 * Used as part of JUnit testing to allow logging statements to
 * be exercised but no logging produced.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class NullHandler
    extends Handler
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Handler Abstract Method Implementation.
    //

    /**
     * Quietly ignores the log record.
     * @param logRecord do not store this record.
     */
    // This callback does nothing and so the method body is
    // empty.
    @SuppressWarnings({"java:S1186"})
    @Override
    public void publish(LogRecord logRecord)
    {}

    /**
     * Does nothing since there is nothing to flush
     */
    // This callback does nothing and so the method body is
    // empty.
    @SuppressWarnings({"java:S1186"})
    @Override
    public void flush()
    {}

    /**
     * Does nothing since there is nothing to close.
     */
    // This callback does nothing and so the method body is
    // empty.
    @SuppressWarnings({"java:S1186"})
    @Override
    public void close()
    {}

    //
    // end of Handler Abstract Method Implementation.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//
} // end of class NullHandler
