/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;

public final class JarFileLoader
extends URLClassLoader {
    public static final String URL_FORMAT = "jar:file:///%s!/";

    public JarFileLoader(URL[] urls) {
        super(urls);
    }

    public JarFileLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public JarFileLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public Package[] packages() {
        Package[] pkgs = this.getPackages();
        return Arrays.copyOf(pkgs, pkgs.length);
    }

    public void addJar(String path) throws IOException {
        File jarFile = new File(path);
        if (!jarFile.exists()) {
            throw new FileNotFoundException(String.format("%s does not exist", path));
        }
        if (!jarFile.isFile()) {
            throw new IOException(String.format("%s is not a regular file", path));
        }
        if (!jarFile.canRead()) {
            throw new IOException(String.format("%s cannot be read", path));
        }
        this.addURL(new URL(String.format(URL_FORMAT, jarFile.getAbsolutePath())));
    }
}

