//
// Copyright 2001 - 2008 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

/**
 * Classes using {@link net.sf.eBus.util.TimerTask TimerTask}
 * should implement this interface. It allows them to receive
 * timer expiration notifications.
 * <p>
 * As of eBus v. 4.2.0, this interface is marked as
 * {@code @FunctionalInterface}. This allows this interface to
 * be defined using a lambda expression.
 * </p>
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

@FunctionalInterface
public interface TimerTaskListener
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * This method is called when the
     * {@link net.sf.eBus.util.TimerTask TimerTask} has expired.
     * @param task the timer event (the event source is the
     * {@link net.sf.eBus.util.TimerTask} object).
     */
    void handleTimeout(TimerEvent task);
} // end of interface TimerTaskListener
