/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ShutdownHook
extends Thread {
    private static ShutdownHook sInstance = null;
    private static final Lock sLock = new ReentrantLock();
    private final CountDownLatch mSignal;

    private ShutdownHook(CountDownLatch signal) {
        this.mSignal = signal;
    }

    @Override
    public void run() {
        this.mSignal.countDown();
    }

    public static CountDownLatch addShutdownHook() {
        CountDownLatch retval;
        sLock.lock();
        try {
            if (sInstance != null) {
                retval = ShutdownHook.sInstance.mSignal;
            } else {
                retval = new CountDownLatch(1);
                sInstance = new ShutdownHook(retval);
                Runtime.getRuntime().addShutdownHook(sInstance);
            }
        }
        finally {
            sLock.unlock();
        }
        return retval;
    }

    public static void removeShutdownHook() {
        sLock.lock();
        try {
            if (sInstance != null) {
                Runtime.getRuntime().removeShutdownHook(sInstance);
                sInstance = null;
            }
        }
        finally {
            sLock.unlock();
        }
    }
}

