/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.util.List;
import net.sf.eBus.util.MultiKey2;
import net.sf.eBus.util.Validator;

public final class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 328192L;
    private final Class<?> mClass;
    private final List<MultiKey2<String, String>> mProblems;

    public ValidationException(Class<?> tc, List<MultiKey2<String, String>> problems) {
        super(ValidationException.asMessage(tc, problems));
        this.mClass = tc;
        this.mProblems = problems;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public Class<?> targetClass() {
        return this.mClass;
    }

    public List<MultiKey2<String, String>> problems() {
        return this.mProblems;
    }

    private static String asMessage(Class<?> tc, List<MultiKey2<String, String>> problems) {
        StringBuilder retval = new StringBuilder();
        retval.append(tc.getCanonicalName()).append(" failed to build due to the following problems:");
        problems.forEach(p -> retval.append(Validator.NEWLINE).append(p.key(0)).append(": ").append(p.key(1)));
        return retval.toString();
    }
}

