/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.sf.eBus.util.regex.Component;
import net.sf.eBus.util.regex.Pattern;

public final class TernarySearchTree<V>
implements Map<CharSequence, V>,
Serializable {
    private static final int LEFT = 0;
    private static final int CENTER = 1;
    private static final int RIGHT = 2;
    private static final int CHILD_COUNT = 3;
    private static final long serialVersionUID = 328192L;
    private static final String NULL_KEY = "null key";
    private TSTNode<V> mRoot;
    private int mSize;
    private long mNodeCount;

    public TernarySearchTree() {
        this.mRoot = null;
        this.mSize = 0;
        this.mNodeCount = 0L;
    }

    public TernarySearchTree(Map<? extends CharSequence, ? extends V> m) {
        m.entrySet().stream().forEach((? super T entry) -> this.put((CharSequence)entry.getKey(), entry.getValue()));
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    public long nodeCount() {
        return this.mNodeCount;
    }

    @Override
    public void clear() {
        if (this.mRoot != null) {
            this.mRoot.clear();
            this.mSize = 0;
            this.mNodeCount = 0L;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        boolean retcode = false;
        if (key == null) {
            throw new IllegalArgumentException(NULL_KEY);
        }
        TSTNode<V> node = this.findNode((CharSequence)key);
        if (node != null) {
            retcode = node.isKey();
        }
        return retcode;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mRoot != null && this.mRoot.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V retval = null;
        if (key == null) {
            throw new IllegalArgumentException(NULL_KEY);
        }
        TSTNode<V> node = this.findNode((CharSequence)key);
        if (node != null) {
            retval = node.value();
        }
        return retval;
    }

    @Override
    public V put(CharSequence key, V value) {
        int index;
        TSTNode<V> node2 = null;
        int length = key.length();
        int child = 0;
        V retval = null;
        TSTNode<V> node = this.mRoot;
        for (index = 0; node != null && index < length; index += Math.abs(child) * -1 + 1, node = node.child(child + 1)) {
            child = node.split(key.charAt(index));
            node2 = node;
        }
        if (index == length) {
            node = node2;
        } else {
            if (node2 == null) {
                this.mRoot = new TSTNode(key.charAt(index));
                node = this.mRoot;
            } else {
                node = new TSTNode(key.charAt(index));
                node2.child(child + 1, node);
            }
            ++index;
            ++this.mNodeCount;
            while (index < length) {
                node2 = new TSTNode(key.charAt(index));
                node.child(1, node2);
                node = node2;
                ++index;
                ++this.mNodeCount;
            }
        }
        if (node != null) {
            if (!node.isKey()) {
                node.key(true, key);
                ++this.mSize;
            }
            retval = node.value(value);
        }
        return retval;
    }

    @Override
    public void putAll(Map<? extends CharSequence, ? extends V> map) {
        map.entrySet().stream().forEach((? super T entry) -> this.put((CharSequence)entry.getKey(), entry.getValue()));
    }

    @Override
    public V remove(Object key) {
        Object retval = null;
        if (key == null) {
            throw new IllegalArgumentException(NULL_KEY);
        }
        TSTNode<V> node = this.findNode((CharSequence)key);
        if (node != null) {
            retval = node.value(null);
            node.key(false, null);
            --this.mSize;
        }
        return retval;
    }

    @Override
    public Set<CharSequence> keySet() {
        HashSet<CharSequence> retval = new HashSet<CharSequence>();
        if (this.mRoot != null) {
            Set<Map.Entry<CharSequence, V>> entries = this.entrySet();
            entries.stream().forEach((? super T e) -> retval.add((CharSequence)e.getKey()));
        }
        return retval;
    }

    public Set<CharSequence> keySet(Pattern query) {
        HashSet<CharSequence> retval = new HashSet<CharSequence>();
        if (this.mRoot != null) {
            Set<Map.Entry<CharSequence, V>> entries = this.entrySet(query);
            entries.stream().forEach((? super T entry) -> retval.add((CharSequence)entry.getKey()));
        }
        return retval;
    }

    public Set<CharSequence> keySet(Pattern query, int maxMatches) {
        HashSet<CharSequence> retval = new HashSet<CharSequence>();
        if (this.mRoot != null) {
            Set<Map.Entry<CharSequence, V>> entries = this.entrySet(query, maxMatches);
            entries.stream().forEach((? super T entry) -> retval.add((CharSequence)entry.getKey()));
        }
        return retval;
    }

    @Override
    public Collection<V> values() {
        ArrayList retval = new ArrayList();
        if (this.mRoot != null) {
            Set<Map.Entry<CharSequence, V>> entries = this.entrySet();
            entries.stream().forEach((? super T e) -> retval.add(e.getValue()));
        }
        return retval;
    }

    public Collection<V> values(Pattern query) {
        LinkedList retval = new LinkedList();
        if (this.mRoot != null) {
            Set<Map.Entry<CharSequence, V>> entries = this.entrySet(query);
            entries.stream().forEach((? super T entry) -> retval.add(entry.getValue()));
        }
        return retval;
    }

    public Collection<V> values(Pattern query, int maxMatches) {
        ArrayList retval = new ArrayList();
        if (this.mRoot != null) {
            Set<Map.Entry<CharSequence, V>> entries = this.entrySet(query, maxMatches);
            entries.stream().forEach((? super T entry) -> retval.add(entry.getValue()));
        }
        return retval;
    }

    @Override
    public Set<Map.Entry<CharSequence, V>> entrySet() {
        HashSet<Map.Entry<CharSequence, V>> retval = new HashSet<Map.Entry<CharSequence, V>>();
        if (this.mRoot != null) {
            this.entries(this.mRoot, retval);
        }
        return retval;
    }

    public Set<Map.Entry<CharSequence, V>> entrySet(Pattern query) {
        HashSet<Map.Entry<CharSequence, V>> retval = new HashSet<Map.Entry<CharSequence, V>>();
        if (this.mRoot != null) {
            Component[] components = query.components();
            LinkedList<TSTSearch<V>> queue = new LinkedList<TSTSearch<V>>();
            queue.add(new TSTSearch<V>(this.mRoot, 0, 0));
            this.entries(components, queue, retval, Integer.MAX_VALUE);
        }
        return retval;
    }

    public Set<Map.Entry<CharSequence, V>> entrySet(Pattern query, int maxMatches) {
        HashSet<Map.Entry<CharSequence, V>> retval = new HashSet<Map.Entry<CharSequence, V>>();
        if (maxMatches <= 0) {
            throw new IllegalArgumentException("maxMatches <= 0 (" + Integer.toString(maxMatches) + ")");
        }
        if (this.mRoot != null) {
            Component[] components = query.components();
            LinkedList<TSTSearch<V>> queue = new LinkedList<TSTSearch<V>>();
            queue.add(new TSTSearch<V>(this.mRoot, 0, 0));
            this.entries(components, queue, retval, maxMatches);
        }
        return retval;
    }

    public Collection<CharSequence> nearSearch(CharSequence s, int distance) {
        TSTSearch searchNode;
        int maxIndex = s.length() - 1;
        LinkedList queue = new LinkedList();
        ArrayList<CharSequence> retval = new ArrayList<CharSequence>();
        queue.add(new TSTSearch<V>(this.mRoot, 0, distance));
        while ((searchNode = (TSTSearch)queue.poll()) != null) {
            TSTNode child;
            TSTNode node = searchNode.node();
            int index = searchNode.index();
            int d = searchNode.matchCount();
            char c = s.charAt(index);
            char splitChar = node.splitChar();
            if ((d > 0 || c < splitChar) && (child = node.child(0)) != null) {
                queue.add(new TSTSearch(child, index, d));
            }
            if (d > 0 || c == splitChar) {
                if (node.isKey() && index == maxIndex) {
                    retval.add(node.key());
                } else if (index < maxIndex && (child = node.child(1)) != null) {
                    queue.add(new TSTSearch(child, index + 1, c == splitChar ? d : d - 1));
                }
            }
            if (d <= 0 && c <= splitChar || (child = node.child(2)) == null) continue;
            queue.add(new TSTSearch(child, index, d));
        }
        return retval;
    }

    private TSTNode<V> findNode(CharSequence key) {
        int index;
        int child;
        TSTNode<V> node2 = null;
        int length = key.length();
        TSTNode<V> node = this.mRoot;
        for (index = 0; node != null && index < length; index += Math.abs(child) * -1 + 1, node = node.child(child + 1)) {
            child = node.split(key.charAt(index));
            node2 = node;
        }
        return index == length ? node2 : null;
    }

    private void entries(TSTNode<V> node, Set<Map.Entry<CharSequence, V>> m) {
        if (node != null) {
            if (node.isKey()) {
                m.add(new TSTEntry<V>(node));
            }
            this.entries(node.child(0), m);
            this.entries(node.child(1), m);
            this.entries(node.child(2), m);
        }
    }

    private void entries(Component[] components, Queue<TSTSearch<V>> queue, Set<Map.Entry<CharSequence, V>> m, int maxMatches) {
        TSTSearch<V> searchNode;
        int length = components.length;
        this.mSize = 0;
        while ((searchNode = queue.poll()) != null && this.mSize < maxMatches) {
            TSTNode<V> nextNode;
            TSTNode<V> node = searchNode.node();
            int index = searchNode.index();
            int matchCount = searchNode.matchCount();
            char splitChar = node.splitChar();
            if (components[index].lessThan(splitChar) && (nextNode = node.child(0)) != null) {
                queue.add(new TSTSearch<V>(nextNode, index, matchCount));
            }
            if (components[index].equalTo(splitChar) || components[index].minimumSize() == 0) {
                int minSize = components[index].minimumSize();
                int maxSize = components[index].maximumSize();
                int nextIndex = index + 1;
                nextNode = node.child(1);
                int nextMatchCount = matchCount + 1;
                if (node.isKey() && nextMatchCount >= minSize) {
                    int minRemaining = 0;
                    for (int i = nextIndex; i < length; ++i) {
                        minRemaining += components[i].minimumSize();
                    }
                    if (minRemaining == 0) {
                        ++this.mSize;
                        m.add(new TSTEntry<V>(node));
                    }
                }
                if ((nextMatchCount < maxSize || maxSize == -1) && nextNode != null) {
                    queue.add(new TSTSearch<V>(nextNode, index, nextMatchCount));
                }
                if (nextMatchCount >= minSize && nextIndex < length && nextNode != null) {
                    queue.add(new TSTSearch<V>(nextNode, nextIndex, 0));
                }
                if (nextMatchCount > minSize && nextIndex < length) {
                    queue.add(new TSTSearch<V>(node, nextIndex, 0));
                }
            }
            if (!components[index].greaterThan(splitChar) || (nextNode = node.child(2)) == null) continue;
            queue.add(new TSTSearch<V>(nextNode, index, matchCount));
        }
    }

    private static final class TSTSearch<V> {
        private final TSTNode<V> mNode;
        private final int mIndex;
        private final int mMatchCount;

        public TSTSearch(TSTNode<V> node, int index, int matchCount) {
            this.mNode = node;
            this.mIndex = index;
            this.mMatchCount = matchCount;
        }

        public TSTNode<V> node() {
            return this.mNode;
        }

        public int index() {
            return this.mIndex;
        }

        public int matchCount() {
            return this.mMatchCount;
        }
    }

    private static final class TSTEntry<V>
    implements Map.Entry<CharSequence, V> {
        private final TSTNode<V> mNode;

        public TSTEntry(TSTNode<V> node) {
            if (!node.isKey()) {
                throw new IllegalArgumentException("non-key node");
            }
            this.mNode = node;
        }

        @Override
        public CharSequence getKey() {
            return this.mNode.mKey;
        }

        @Override
        public V getValue() {
            return this.mNode.mValue;
        }

        @Override
        public V setValue(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof TSTEntry) {
                TSTEntry entry = (TSTEntry)o;
                retcode = this.mNode == entry.mNode;
            }
            return retcode;
        }

        @Override
        public int hashCode() {
            return this.mNode.hashCode();
        }

        public String toString() {
            return String.format("\"%s\"=%s", this.mNode.mKey, this.mNode.mValue);
        }
    }

    private static final class TSTNode<V>
    implements Serializable {
        private static final long serialVersionUID = 328192L;
        private final char mSplitChar;
        private final TSTNode[] mChildren;
        private boolean mKeyFlag;
        private CharSequence mKey;
        private V mValue;

        public TSTNode(char c) {
            this.mSplitChar = c;
            this.mChildren = new TSTNode[3];
            this.mKeyFlag = false;
            this.mValue = null;
        }

        public char splitChar() {
            return this.mSplitChar;
        }

        public TSTNode<V> child(int index) {
            return this.mChildren[index];
        }

        public boolean isKey() {
            return this.mKeyFlag;
        }

        public CharSequence key() {
            return this.mKey;
        }

        public V value() {
            return this.mValue;
        }

        public boolean containsValue(Object value) {
            boolean retcode;
            boolean bl = retcode = this.mKeyFlag && TSTNode.equalObjects(this.mValue, value);
            if (!retcode) {
                for (int index = 0; index < this.mChildren.length && !retcode; ++index) {
                    if (this.mChildren[index] == null) continue;
                    retcode = this.mChildren[index].containsValue(value);
                }
            }
            return retcode;
        }

        public void child(int index, TSTNode<V> node) {
            this.mChildren[index] = node;
        }

        public void key(boolean flag, CharSequence key) {
            this.mKeyFlag = flag;
            this.mKey = key;
        }

        public V value(V value) {
            V retval = this.mValue;
            this.mValue = value;
            return retval;
        }

        public int split(char c) {
            int index = c - this.mSplitChar;
            if (index != 0) {
                index /= Math.abs(index);
            }
            return index;
        }

        public void clear() {
            for (int index = 0; index < this.mChildren.length; ++index) {
                if (this.mChildren[index] == null) continue;
                this.mChildren[index].clear();
                this.mChildren[index] = null;
            }
        }

        private static boolean equalObjects(Object o1, Object o2) {
            return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
        }
    }
}

