//
// Copyright 2004 - 2008 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

import java.util.EventObject;

/**
 * Contains the updated {@link Properties} object as event
 * source. Retrieve the Properties object by calling
 * {@code getSource()} and casting the return value
 * to {@link Properties}.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class PropertiesEvent
    extends EventObject
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     *  This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x050200L;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * The specified properties have changed.
     * @param properties the event's source.
     * @throws IllegalArgumentException
     * if {@code properties} is {@code null}.
     */
    public PropertiesEvent(final Properties properties)
    {
        super (properties);
    } // end of PropertiesEvent(Properties)

    //
    // end of Constructors.
    //-----------------------------------------------------------
} // end of class PropertiesEvent
