/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.eBus.util.PropertiesEvent;
import net.sf.eBus.util.PropertiesListener;

public final class Properties
extends java.util.Properties {
    private static final long serialVersionUID = 328192L;
    private static final String THREAD_SUFFIX = "WatchThread";
    private static Map<String, Properties> sPropertiesMap = new HashMap<String, Properties>();
    private static Lock sPropertiesMutex = new ReentrantLock();
    private static final Logger sLogger = Logger.getLogger(Properties.class.getName());
    private final String mFileName;
    private final transient List<PropertiesListener> mListeners;
    private transient WatchThread mWatchThread;

    public Properties() {
        this.mFileName = null;
        this.mListeners = new LinkedList<PropertiesListener>();
        this.mWatchThread = null;
    }

    public Properties(java.util.Properties defaults) {
        super(defaults);
        this.mFileName = null;
        this.mListeners = new LinkedList<PropertiesListener>();
        this.mWatchThread = null;
    }

    private Properties(String fileName) {
        this.mFileName = fileName;
        this.mListeners = new LinkedList<PropertiesListener>();
        this.mWatchThread = null;
    }

    public boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        boolean retval = false;
        if (value != null) {
            Boolean bool = Boolean.valueOf(value.trim());
            retval = bool;
        }
        return retval;
    }

    public int getIntProperty(String key) {
        String value = this.getProperty(key);
        int retval = 0;
        if (value != null && value.length() > 0) {
            try {
                retval = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retval;
    }

    public double getDoubleProperty(String key) {
        String value = this.getProperty(key);
        double retval = 0.0;
        if (value != null && value.length() > 0) {
            try {
                retval = Double.parseDouble(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retval;
    }

    public String[] getArrayProperty(String key, char ifs) {
        String value = this.getProperty(key);
        String[] retval = value == null || value.length() == 0 ? new String[]{} : value.split(String.format("[%c]", Character.valueOf(ifs)));
        return retval;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        boolean retval = defaultValue;
        if (!Strings.isNullOrEmpty((String)value)) {
            retval = Boolean.valueOf(value.trim());
        }
        return retval;
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        int retval = defaultValue;
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                retval = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retval;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String value = this.getProperty(key);
        double retval = defaultValue;
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                retval = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retval;
    }

    public Set<String> stringPropertyNames(Pattern p) {
        TreeSet<String> retval = new TreeSet<String>(this.stringPropertyNames());
        Iterator it = retval.iterator();
        while (it.hasNext()) {
            Matcher m = p.matcher((CharSequence)it.next());
            if (m.matches()) continue;
            it.remove();
        }
        return retval;
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setDoubleProperty(String key, double value) {
        this.setProperty(key, Double.toString(value));
    }

    public void setArrayProperty(String key, String[] value, char ifs) {
        String newValue = "";
        if (value.length > 0) {
            int i;
            int bufferLen = 0;
            for (i = 0; i < value.length; ++i) {
                bufferLen += value[i].length();
            }
            StringBuilder buffer = new StringBuilder(bufferLen += value.length - 1);
            for (i = 0; i < value.length; ++i) {
                if (i > 0) {
                    buffer.append(ifs);
                }
                buffer.append(value[i]);
            }
            newValue = buffer.toString();
        }
        this.setProperty(key, newValue);
    }

    public void load() throws IOException {
        if (this.mFileName == null) {
            throw new IOException("no property file to load");
        }
        try (FileInputStream fis = new FileInputStream(this.mFileName);){
            this.load(fis);
        }
        catch (FileNotFoundException nofilex) {
            throw new IOException(this.mFileName + " does not exist");
        }
    }

    public void store(String header) throws IOException {
        if (this.mFileName == null) {
            throw new IOException("no property file");
        }
        try (FileOutputStream fos = new FileOutputStream(this.mFileName);){
            this.store(fos, header);
        }
    }

    public void store(String fileName, String header) throws IOException {
        if (Strings.isNullOrEmpty((String)fileName)) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        this.store(new File(fileName), header);
    }

    public void store(File file, String header) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        boolean existsFlag = file.exists();
        if (existsFlag && file.isDirectory()) {
            throw new IOException(file.getName() + " is a directory");
        }
        if (existsFlag && !file.canWrite()) {
            throw new IOException(file.getName() + " is unwriteable");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.store(fos, header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PropertiesListener listener) {
        boolean addFlag = false;
        int listenerSize = 0;
        if (this.mFileName == null) {
            throw new IllegalStateException("no underlying property file");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        List<PropertiesListener> list = this.mListeners;
        synchronized (list) {
            if (!this.mListeners.contains(listener)) {
                this.mListeners.add(listener);
                addFlag = true;
                listenerSize = this.mListeners.size();
            }
        }
        if (addFlag && listenerSize == 1) {
            try {
                File f = new File(this.mFileName).getAbsoluteFile();
                FileSystem fs = FileSystems.getDefault();
                Path p = fs.getPath(f.getParent(), new String[0]);
                Path fp = fs.getPath(f.getName(), new String[0]);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine(String.format("Watching %s properties file.", this.mFileName));
                }
                WatchService watcher = fs.newWatchService();
                WatchKey key = p.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.mWatchThread = new WatchThread(fp, key, watcher, String.format("%s%s", f.getName(), THREAD_SUFFIX), this);
                this.mWatchThread.start();
            }
            catch (IOException ioex) {
                sLogger.log(Level.WARNING, "File watch failed.", ioex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PropertiesListener listener) {
        if (this.mFileName == null) {
            throw new IllegalStateException("no underlying property file");
        }
        if (listener != null) {
            boolean removeFlag = false;
            boolean emptyFlag = false;
            List<PropertiesListener> list = this.mListeners;
            synchronized (list) {
                if (this.mListeners.contains(listener)) {
                    this.mListeners.remove(listener);
                    removeFlag = true;
                    emptyFlag = this.mListeners.isEmpty();
                }
            }
            if (removeFlag && emptyFlag) {
                this.mWatchThread.cancel();
                this.mWatchThread = null;
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine(String.format("Stopped watching %s properties file.", this.mFileName));
                }
            }
        }
    }

    public static Properties loadProperties(String fileName) throws IOException {
        Properties retval = null;
        if (Strings.isNullOrEmpty((String)fileName)) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        retval = Properties.loadProperties(new File(fileName));
        return retval;
    }

    public static Properties loadProperties(File file) throws IOException {
        Properties retval = null;
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        boolean existsFlag = file.exists();
        if (existsFlag && file.isDirectory()) {
            throw new IOException(file.getName() + " is a directory");
        }
        if (existsFlag && !file.canRead()) {
            throw new IOException(file.getName() + " is unreadable");
        }
        String fileName = file.getPath();
        sPropertiesMutex.lock();
        try {
            retval = sPropertiesMap.get(fileName);
            if (retval == null) {
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine(String.format("Loading %s properties file.", fileName));
                }
                retval = Properties.createInstance(file, fileName, existsFlag);
            }
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            sPropertiesMutex.unlock();
        }
        return retval;
    }

    private static Properties createInstance(File file, String fileName, boolean existsFlag) throws IOException {
        Properties retval = new Properties(fileName);
        sPropertiesMap.put(fileName, retval);
        if (existsFlag) {
            try (FileInputStream fis = new FileInputStream(file);){
                retval.load(fis);
            }
            catch (IOException ioex) {
                sPropertiesMap.remove(fileName);
                throw ioex;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileEvent(WatchEvent<?> event) {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("Properties event: %s.", event.kind().name()));
        }
        try {
            PropertiesEvent propEvent = new PropertiesEvent(this);
            LinkedList<PropertiesListener> listeners = new LinkedList<PropertiesListener>();
            this.load();
            List<PropertiesListener> list = this.mListeners;
            synchronized (list) {
                listeners.addAll(this.mListeners);
            }
            listeners.stream().forEach((? super T listener) -> {
                try {
                    listener.propertiesUpdate(propEvent);
                }
                catch (Exception jex) {
                    sLogger.log(Level.WARNING, "Properties listener exception.", jex);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final class WatchThread
    extends Thread {
        private final Path mPropertiesFile;
        private final WatchKey mKey;
        private final WatchService mWatcher;
        private final Properties mOwner;

        public WatchThread(Path propFile, WatchKey key, WatchService watcher, String name, Properties owner) {
            super(name);
            this.mPropertiesFile = propFile;
            this.mKey = key;
            this.mWatcher = watcher;
            this.mOwner = owner;
        }

        @Override
        public void run() {
            boolean runFlag = true;
            while (runFlag) {
                try {
                    this.mWatcher.take();
                    this.mKey.pollEvents().stream().filter(e -> e.kind() != StandardWatchEventKinds.OVERFLOW && e.context().equals(this.mPropertiesFile)).forEach(x$0 -> this.mOwner.handleFileEvent((WatchEvent<?>)x$0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                runFlag = this.mKey.reset();
            }
        }

        public void cancel() {
            this.mKey.cancel();
            this.interrupt();
        }
    }
}

