/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public final class IndexPool
implements Serializable {
    private static final long serialVersionUID = 328192L;
    private AtomicInteger mNextIndex;
    private final int mMinIndex;
    private final int mMaxIndex;
    private ConcurrentLinkedDeque<Integer> mPool;

    public IndexPool() {
        this(0, Integer.MAX_VALUE);
    }

    public IndexPool(int minIndex, int maxIndex) {
        if (minIndex < 0) {
            throw new IllegalArgumentException("minIndex < 0 (" + Integer.toString(minIndex) + ")");
        }
        if (maxIndex < 0) {
            throw new IllegalArgumentException("maxIndex < 0 (" + Integer.toString(maxIndex) + ")");
        }
        if (minIndex > maxIndex) {
            throw new IllegalArgumentException("minIndex (" + Integer.toString(minIndex) + " > maxIndex (" + Integer.toString(maxIndex) + ")");
        }
        this.mNextIndex = new AtomicInteger(minIndex);
        this.mMinIndex = minIndex;
        this.mMaxIndex = maxIndex;
        this.mPool = new ConcurrentLinkedDeque();
    }

    public String toString() {
        String separator = "";
        StringBuilder retval = new StringBuilder();
        retval.append("minimum index = ").append(this.mMinIndex).append("\nmaximum index = ").append(this.mMaxIndex).append("\ncached indices = {");
        Iterator<Integer> pit = this.mPool.iterator();
        while (pit.hasNext()) {
            retval.append(separator).append(pit.next());
            separator = ", ";
        }
        retval.append("}\nnext index = ").append(this.mNextIndex.get());
        return retval.toString();
    }

    public int minIndex() {
        return this.mMinIndex;
    }

    public int maxIndex() {
        return this.mMaxIndex;
    }

    public int nextIndex() {
        Integer retval = this.mPool.pollFirst();
        if (retval == null && (retval = Integer.valueOf(this.mNextIndex.getAndIncrement())) > this.mMaxIndex) {
            throw new IllegalStateException("index pool is exhausted");
        }
        return retval;
    }

    public void returnIndex(int index) {
        if (index < this.mMinIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(index) + " < minimum index" + Integer.toString(this.mMinIndex));
        }
        if (index > this.mMaxIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(index) + " > maximum index" + Integer.toString(this.mMaxIndex));
        }
        this.mPool.add(index);
    }

    public void reset() {
        this.mNextIndex.set(this.mMinIndex);
        this.mPool.clear();
    }
}

