//
// Copyright 2005 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

/**
 * This {@link MultiKey} subclass uses generics to guarantee
 * key type and order. {@link MultiKey} is unable to provide
 * this type safety.
 * @param <K1> The first key.
 * @param <K2> The second key.
 * @param <K3> The third key.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public class MultiKey3<K1, K2, K3>
    extends MultiKey
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     *  This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x050200L;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a three value {@link MultiKey}.
     * @param key1 the first key.
     * @param key2 the second key.
     * @param key3 the third key.
     */
    public MultiKey3(final K1 key1, final K2 key2, final K3 key3)
    {
        super (key1, key2, key3);
    } // end of MultiKey3(K1, K2, K3)

    //
    // end of Constructors.
    //-----------------------------------------------------------
} // end of class MultiKey3
