/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.util.regex;

import java.io.Serializable;

public abstract class Component
implements Serializable {
    public static final int NO_MAX_MATCH_LIMIT = -1;
    public static final int LITERAL = 1;
    public static final int CHARACTER_SET = 2;
    public static final int ANY_CHAR = 3;
    private static final long serialVersionUID = 328192L;
    protected final int mType;
    protected final int mMinimumSize;
    protected final int mMaximumSize;
    protected final int mIndex;

    protected Component(int type, int minLength, int maxLength, int index) {
        this.mType = type;
        this.mMinimumSize = minLength;
        this.mMaximumSize = maxLength;
        this.mIndex = index;
    }

    public final int type() {
        return this.mType;
    }

    public final int minimumSize() {
        return this.mMinimumSize;
    }

    public final int maximumSize() {
        return this.mMaximumSize;
    }

    public final int index() {
        return this.mIndex;
    }

    public abstract boolean lessThan(char var1);

    public abstract boolean equalTo(char var1);

    public abstract boolean greaterThan(char var1);

    protected void appendSize(StringBuilder buffer) {
        if (this.mMinimumSize != 1 || this.mMaximumSize != 1) {
            if (this.mMinimumSize == 0 && this.mMaximumSize == -1) {
                buffer.append('*');
            } else if (this.mMinimumSize == 1 && this.mMaximumSize == -1) {
                buffer.append('+');
            } else {
                buffer.append('{');
                if (this.mMinimumSize > 0) {
                    buffer.append(this.mMinimumSize);
                }
                buffer.append(',');
                if (this.mMaximumSize > 0) {
                    buffer.append(this.mMaximumSize);
                }
                buffer.append('}');
            }
        }
    }
}

