//
// Copyright 2012 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * Contains supporting utility Java classes for
 * <code>net.sf.eBus</code>. These utilities either provide
 * capabilities not provided by the Java standard edition or
 * extend existing Java classes:
 * <ul>
 *   <li>
 *       {@link net.sf.eBus.util.SequentialTask}: If tasks
 *       associated with the <i>same object</i> must execute in
 *       chronological order,
 *       {@link net.sf.eBus.util.SequentialTask} guarantees that
 *       ordering. Tasks associated with different objects can
 *       execute in parallel.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.HexDump}: Binary data hex dump
 *     generator.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.IndexCache IndexCache}: Stores the
 *     latest index value in a specified file. This class is used
 *     when a unique index value must be maintained across an
 *     application's separate executions. IndexCache does not
 *     support index sharing by multiple applications running
 *     simultaneously. It is designed to work with a single
 *     application only.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.IndexPool IndexPool}: Tracks which
 *     integer indices are in use and returns to the caller the
 *     minimum index available. For example, if you need to use
 *     an index value between 0 and 99 inclusive and indices
 *     0, 1 and 3 are in use, then
 *     {@link net.sf.eBus.util.IndexPool#nextIndex}
 *     returns 2. The application is responsible for informing
 *     {@link net.sf.eBus.util.IndexPool} when an index in no
 *     longer in use by calling
 *     {@link net.sf.eBus.util.IndexPool#returnIndex(int)}.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.MultiKey MultiKey}: Allows
 *     multiple objects to be used as a single Java map key.
 *     Obviates the need for nested maps.
 *     <p>
 *       The multikey code belongs to Howard Lewis Ship and
 *       Stephen Colebourne and is under the Apache license.
 *     </p>
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.Properties Properties}: Extends
 *     <code>java.lang.Properties</code> class. Provides access to
 *     multiple property files and additional methods for
 *     retrieving <code>boolean</code>, <code>int</code>,
 *     <code>double</code> and <code>String[]</code> arrays from
 *     a properties list or placing into the properties list.
 *     Also provides
 *     {@link net.sf.eBus.util.Properties#addListener(PropertiesListener)} and
 *     {@link net.sf.eBus.util.Properties#removeListener(PropertiesListener)}
 *     methods. When the underlying properties file changes,
 *     Properties reloads the file and then informs all registered
 *     {@link net.sf.eBus.util.PropertiesListener PropertiesListener}s.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.TernarySearchTree TernarySearchTree}:
 *     Implements the Bentley, Sedgewick ternary search tree (TST)
 *     as a Java map. Keys are restricted to Java character
 *     sequences. TST only partially follows the Java Map
 *     interface. The keySet, values and entrySet methods return
 *     collections that are <i>not</i> backed by the map.
 *     Modifying these returned collections does not modify the
 *     map.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.TimerTask TimerTask}: Extends
 *     <code>java.util.TimerTask</code>. Associates a
 *     {@link net.sf.eBus.util.TimerTaskListener} with the
 *     {@link net.sf.eBus.util.TimerTask}. When the timer expires,
 *     {@link net.sf.eBus.util.TimerTaskListener#handleTimeout(TimerEvent)}
 *     is called.
 *   </li>
 * </ul>
 */

package net.sf.eBus.util;
