//
// Copyright 2012 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * Supplements {@code java.util.logging} package with a
 * rolling log file handler, a pattern formatter and a logged
 * status report.
 * <ul>
 *   <li>
 *     {@link net.sf.eBus.util.logging.CalendarFileHandler}:
 *     Extends the {@link java.util.logging.StreamHandler} class.
 *     Places each day's log messages in a separate file, rolling
 *     over the log files at midnight. This handler also deletes
 *     any existing log files that are older than the specified
 *     age limit (in days).
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.logging.PatternFormatter}: Extends
 *     the {@link java.util.logging.Formatter} class.
 *     Uses {@code printf}-like format specifiers to layout
 *     how a {@link java.util.logging.LogRecord} should be
 *     formatted.
 *     <p>
 *     The idea for this class came from the Apache Jakarta's
 *     Log4j project class
 *     <code>org.apache.log4j.PatternLayout</code> but is in no
 *     way based on it.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.logging.StatusReport}: Logs an
 *     application status report at a specified interval. The
 *     report consists of generic system information followed
 *     by what each registered
 *     {@link net.sf.eBus.util.logging.StatusReporter} appends to
 *     the report.
 *   </li>
 * </ul>
 */

package net.sf.eBus.util.logging;
