//
// Copyright 2001 - 2008 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util.logging;

import java.io.PrintWriter;

/**
 * Implement this interface when you want an object to append
 * its information to the status report.
 *
 * @see net.sf.eBus.util.logging.StatusReport
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public interface StatusReporter
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Append your report to this buffer.
     * @param report append report to this buffer.
     */
    void reportStatus(PrintWriter report);
} // end of interface StatusReporter
