//
// Copyright 2001 - 2008 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

/**
 * Classes which want to be asynchronously informed about
 * properties changes should implement this interface and
 * add themselves to the properties listeners by calling
 * {@link Properties#addListener(PropertiesListener)}.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public interface PropertiesListener
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * {@link Properties} calls this method when it detects
     * a change in its underlying properties file.
     * @param event The change properties event.
     */
    void propertiesUpdate(PropertiesEvent event);
} // end of interface PropertiesListener
