//
// Copyright 2009 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package net.sf.eBus.util;

import java.util.concurrent.Executor;

/**
 * Performs direct, synchronous runnable task execution in the
 * current thread. This class allows an application to maintain
 * an {@code java.util.Executor} reference and instantiate the
 * appropriate executor subclass which performs either
 * synchronous or asynchronous execution. The application can
 * switch between different task execution styles without
 * changing how it uses the {@code Executor} instance.
 * <p>
 * (Aside: this class should be in java.util.concurrent to
 * provide a complete Executor implementation suite but is
 * not part of the standard Java class library. Hence it
 * being part of the eBus library).
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public class DirectExecutor
    implements Executor
{
//---------------------------------------------------------------
// Member data.
//

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Executor Interface Implementation.
    //

    /**
     * Immediately executes the task in the current thread.
     * @param task Execute this task.
     */
    @Override
    public void execute(final Runnable task)
    {
        task.run();
    } // end of execute(Runnable)

    //
    // end of Executor Interface Implementation.
    //-----------------------------------------------------------
} // end of class DirectExecutor
