//
// Copyright 2012 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * {@link net.sf.eBus.text.TokenLexer} takes a given input and
 * returns a series of analyzed tokens. These tokens contain:
 * <ul>
 *   <li>
 *     A token type. May be either a pre-defined or
 *     user-defined.
 *   </li>
 *   <li>
 *     The token text value as collected from the input.
 *   </li>
 *   <li>
 *     The Java object created from the token text.
 *   </li>
 *   <li>
 *     The line number on which the token appears.
 *   </li>
 * </ul>
 * <p>
 * The most important difference between {@code Lexer} and
 * {@code java.util.StringTokenizer} is that Lexer analyzes the
 * tokens into types. Further, tokens are not created by
 * breaking a line based on inter-field separator characters or
 * by regular expression. Instead, Lexer searches for tokens
 * based on types. This lexical package is designed to work with
 * a higher level parser rather than a line-by-line text
 * processor.
 */

package net.sf.eBus.text;
