/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2012. Charles W. Rapp
 * All Rights Reserved.
 */

/**
 * Supplements {@code java.util.logging} package with a
 * rolling log file handler, a pattern formatter and a logged
 * status report.
 * <ul>
 *   <li>
 *     {@link net.sf.eBus.util.logging.CalendarFileHandler}:
 *     Extends the {@link java.util.logging.StreamHandler} class.
 *     Places each day's log messages in a separate file, rolling
 *     over the log files at midnight. This handler also deletes
 *     any existing log files that are older than the specified
 *     age limit (in days).
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.logging.PatternFormatter}: Extends
 *     the {@link java.util.logging.Formatter} class.
 *     Uses {@code printf}-like format specifiers to layout
 *     how a {@link java.util.logging.LogRecord} should be
 *     formatted.
 *     <p>
 *     The idea for this class came from the Apache Jakarta's
 *     Log4j project class
 *     <code>org.apache.log4j.PatternLayout</code> but is in no
 *     way based on it.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.util.logging.StatusReport}: Logs an
 *     application status report at a specified interval. The
 *     report consists of generic system information followed
 *     by what each registered
 *     {@link net.sf.eBus.util.logging.StatusReporter} appends to
 *     the report.
 *   </li>
 * </ul>
 */

package net.sf.eBus.util.logging;
