//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2001 - 2005. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util;

import java.util.EventObject;

/**
 * A {@code TimerEvent} event is sent to those
 * {@link net.sf.eBus.util.TimerTaskListener} objects registered
 * with an expired {@link net.sf.eBus.util.TimerTask}.
 * <p>
 * <i>Note:</i> The event's source is a
 * {@link net.sf.eBus.util.TimerTask}.
 * @see net.sf.eBus.util.TimerTask
 * @see net.sf.eBus.util.TimerTaskListener
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

@SuppressWarnings({"java:S1948"})
public final class TimerEvent
    extends EventObject
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     *  This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x050200L;

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     * The associated value.
     */
    private final Object mValue;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a timer event for the specified timer task.
     * The timer task is the event source.
     * The value is the one passed to
     * {@link net.sf.eBus.util.TimerTask#TimerTask(net.sf.eBus.util.TimerTaskListener, java.lang.Object)}.
     * @param timerTask The event source.
     * @param value The timer's associated value. May be
     * {@code null}.
     * @see net.sf.eBus.util.TimerTask
     */
    public TimerEvent(final TimerTask timerTask,
                      final Object value)
    {
        super (timerTask);

        mValue = value;
    } // end of TimerEvent(TimerTask)

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Get methods.
    //

    /**
     * Returns the timer task associated value. May return
     * {@code null}.
     * @return the timer task associated value.
     */
    public Object value()
    {
        return (mValue);
    } // end of value()

    //
    // end of Get methods.
    //-----------------------------------------------------------

    /**
     * Cancels the underlying {@link TimerTask timer task}.
     * @see TimerTask
     */
    public void cancel()
    {
        ((TimerTask) this.source).cancel();
    } // end of cancel()
} // end of class TimerEvent

//
// CHANGE LOG
// $Log: TimerEvent.java,v $
// Revision 1.1  2005/07/22 01:39:20  charlesr
// Move to Java 5.
//
// Revision 1.0  2003/11/20 01:47:18  charlesr
// Initial revision
//
