//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2009. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.util;

import java.util.concurrent.Executor;

/**
 * Performs direct, synchronous runnable task execution in the
 * current thread. This class allows an application to maintain
 * an {@code java.util.Executor} reference and instantiate the
 * appropriate executor subclass which performs either
 * synchronous or asynchronous execution. The application can
 * switch between different task execution styles without
 * changing how it uses the {@code Executor} instance.
 * <p>
 * (Aside: this class should be in java.util.concurrent to
 * provide a complete Executor implementation suite but is
 * not part of the standard Java class library. Hence it
 * being part of the eBus library).
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public class DirectExecutor
    implements Executor
{
//---------------------------------------------------------------
// Member data.
//

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Executor Interface Implementation.
    //

    /**
     * Immediately executes the task in the current thread.
     * @param task Execute this task.
     */
    @Override
    public void execute(final Runnable task)
    {
        task.run();
    } // end of execute(Runnable)

    //
    // end of Executor Interface Implementation.
    //-----------------------------------------------------------
} // end of class DirectExecutor
